/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.group;

import java.util.List;
import java.util.Set;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.property.PropertyHolder;
import net.potatocloud.api.service.Service;

public interface ServiceGroup
extends PropertyHolder {
    public String getName();

    public String getPlatformName();

    default public Platform getPlatform() {
        return CloudAPI.getInstance().getPlatformManager().getPlatform(this.getPlatformName());
    }

    public String getPlatformVersionName();

    default public PlatformVersion getPlatformVersion() {
        return this.getPlatform().getVersion(this.getPlatformVersionName());
    }

    public List<String> getServiceTemplates();

    public int getMinOnlineCount();

    public void setMinOnlineCount(int var1);

    public int getMaxOnlineCount();

    public void setMaxOnlineCount(int var1);

    default public Set<CloudPlayer> getOnlinePlayers() {
        return CloudAPI.getInstance().getPlayerManager().getOnlinePlayersByGroup(this);
    }

    default public int getOnlinePlayerCount() {
        return this.getOnlinePlayers().size();
    }

    public int getMaxPlayers();

    public void setMaxPlayers(int var1);

    public int getMaxMemory();

    public void setMaxMemory(int var1);

    public boolean isFallback();

    public void setFallback(boolean var1);

    public boolean isStatic();

    public int getStartPriority();

    public void setStartPriority(int var1);

    public int getStartPercentage();

    public void setStartPercentage(int var1);

    public String getJavaCommand();

    public List<String> getCustomJvmFlags();

    public void addCustomJvmFlag(String var1);

    public void addServiceTemplate(String var1);

    public void removeServiceTemplate(String var1);

    default public List<Service> getAllServices() {
        return CloudAPI.getInstance().getServiceManager().getAllServices(this.getName());
    }

    default public List<Service> getOnlineServices() {
        return CloudAPI.getInstance().getServiceManager().getOnlineServices(this.getName());
    }

    default public int getOnlineServiceCount() {
        return this.getOnlineServices().size();
    }

    default public void update() {
        CloudAPI.getInstance().getServiceGroupManager().updateServiceGroup(this);
    }
}

