/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.platform;

import java.util.List;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.platform.PlatformVersion;

public interface Platform {
    public String getName();

    public String getDownloadUrl();

    public boolean isCustom();

    public boolean isProxy();

    public List<PlatformVersion> getVersions();

    public void setVersions(List<PlatformVersion> var1);

    public List<String> getPrepareSteps();

    public String getBase();

    public String getPreCacheBuilder();

    public String getParser();

    public String getHashType();

    public void addVersion(PlatformVersion var1);

    default public void update() {
        CloudAPI.getInstance().getPlatformManager().updatePlatform(this);
    }

    default public PlatformVersion getVersion(String name) {
        return this.getVersions().stream().filter(version -> version.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    default public boolean hasVersion(String name) {
        return this.getVersion(name) != null;
    }

    default public boolean isBukkitBased() {
        return this.getBase().equalsIgnoreCase("bukkit") || this.getBase().equalsIgnoreCase("spigot") || this.isPaperBased();
    }

    default public boolean isPaperBased() {
        return this.getBase().equalsIgnoreCase("paper");
    }

    default public boolean isVelocityBased() {
        return this.getBase().equalsIgnoreCase("velocity");
    }

    default public boolean isLimboBased() {
        return this.getBase().equalsIgnoreCase("limbo");
    }
}

