/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.service;

import java.util.Set;
import java.util.stream.Collectors;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.property.PropertyHolder;
import net.potatocloud.api.service.ServiceStatus;
import net.potatocloud.api.utils.TimeFormatter;

public interface Service
extends PropertyHolder {
    public String getName();

    public int getServiceId();

    default public boolean isOnline() {
        return this.getStatus() == ServiceStatus.RUNNING;
    }

    public ServiceStatus getStatus();

    public void setStatus(ServiceStatus var1);

    public long getStartTimestamp();

    default public String getFormattedStartTimestamp() {
        return TimeFormatter.formatAsDateAndTime(this.getStartTimestamp());
    }

    default public long getUptime() {
        return System.currentTimeMillis() - this.getStartTimestamp();
    }

    default public String getFormattedUptime() {
        return TimeFormatter.formatAsDuration(this.getUptime());
    }

    default public Set<CloudPlayer> getOnlinePlayers() {
        return CloudAPI.getInstance().getPlayerManager().getOnlinePlayers().stream().filter(player -> this.getName().equals(player.getConnectedServiceName())).collect(Collectors.toSet());
    }

    default public int getOnlinePlayerCount() {
        return this.getOnlinePlayers().size();
    }

    default public boolean isFull() {
        return this.getOnlinePlayerCount() >= this.getMaxPlayers();
    }

    public int getMaxPlayers();

    public void setMaxPlayers(int var1);

    public int getUsedMemory();

    public int getPort();

    public ServiceGroup getServiceGroup();

    public void shutdown();

    public boolean executeCommand(String var1);

    public void copy(String var1, String var2);

    default public void copy(String template) {
        this.copy(template, "");
    }

    default public void update() {
        CloudAPI.getInstance().getServiceManager().updateService(this);
    }
}

