/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.service;

import java.util.List;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.service.Service;

public interface ServiceManager {
    public Service getService(String var1);

    public List<Service> getAllServices();

    default public List<Service> getOnlineServices() {
        return this.getAllServices().stream().filter(Service::isOnline).toList();
    }

    default public List<Service> getAllServices(String groupName) {
        return this.getAllServices().stream().filter(service -> service.getServiceGroup().getName().equals(groupName)).toList();
    }

    default public List<Service> getOnlineServices(String groupName) {
        return this.getOnlineServices().stream().filter(service -> service.getServiceGroup().getName().equals(groupName)).toList();
    }

    public void updateService(Service var1);

    public void startService(String var1);

    default public void startService(ServiceGroup group) {
        this.startService(group.getName());
    }

    public void startServices(String var1, int var2);

    default public void startServices(ServiceGroup group, int count) {
        this.startServices(group.getName(), count);
    }

    public Service getCurrentService();
}

