/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector;

import lombok.Generated;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.connector.group.ServiceGroupManagerImpl;
import net.potatocloud.connector.platform.PlatformManagerImpl;
import net.potatocloud.connector.player.CloudPlayerManagerImpl;
import net.potatocloud.connector.service.ServiceManagerImpl;
import net.potatocloud.core.event.ClientEventManager;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.netty.NettyNetworkClient;

public class ConnectorAPI
extends CloudAPI {
    private static final String NODE_HOST = "127.0.0.1";
    private static final int NODE_PORT = Integer.parseInt(System.getProperty("potatocloud.node.port"));
    private final PacketManager packetManager = new PacketManager();
    private final NetworkClient client = new NettyNetworkClient(this.packetManager);
    private final ServiceGroupManager groupManager;
    private final ServiceManager serviceManager;
    private final PlatformManager platformManager;
    private final CloudPlayerManager playerManager;
    private final ClientEventManager eventManager;

    public ConnectorAPI() {
        this.client.connect(NODE_HOST, NODE_PORT);
        this.groupManager = new ServiceGroupManagerImpl(this.client);
        this.serviceManager = new ServiceManagerImpl(this.client);
        this.platformManager = new PlatformManagerImpl(this.client);
        this.playerManager = new CloudPlayerManagerImpl(this.client);
        this.eventManager = new ClientEventManager(this.client);
    }

    public static ConnectorAPI getInstance() {
        return (ConnectorAPI)CloudAPI.getInstance();
    }

    @Override
    public ServiceGroupManager getServiceGroupManager() {
        return this.groupManager;
    }

    public void shutdown() {
        this.client.disconnect();
    }

    @Generated
    public PacketManager getPacketManager() {
        return this.packetManager;
    }

    @Generated
    public NetworkClient getClient() {
        return this.client;
    }

    @Generated
    public ServiceGroupManager getGroupManager() {
        return this.groupManager;
    }

    @Override
    @Generated
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    @Generated
    public PlatformManager getPlatformManager() {
        return this.platformManager;
    }

    @Override
    @Generated
    public CloudPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    @Generated
    public ClientEventManager getEventManager() {
        return this.eventManager;
    }
}

