/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.group.impl.ServiceGroupImpl;
import net.potatocloud.api.property.Property;
import net.potatocloud.connector.group.listeners.GroupAddListener;
import net.potatocloud.connector.group.listeners.GroupDeleteListener;
import net.potatocloud.connector.group.listeners.GroupUpdateListener;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.packets.group.GroupAddPacket;
import net.potatocloud.core.networking.packets.group.GroupDeletePacket;
import net.potatocloud.core.networking.packets.group.GroupUpdatePacket;
import net.potatocloud.core.networking.packets.group.RequestGroupsPacket;

public class ServiceGroupManagerImpl
implements ServiceGroupManager {
    private final List<ServiceGroup> groups = new ArrayList<ServiceGroup>();
    private final NetworkClient client;

    public ServiceGroupManagerImpl(NetworkClient client) {
        this.client = client;
        client.send(new RequestGroupsPacket());
        client.registerPacketListener(101, new GroupAddListener(this));
        client.registerPacketListener(104, new GroupDeleteListener(this));
        client.registerPacketListener(102, new GroupUpdateListener(this));
    }

    public void addServiceGroup(ServiceGroup group) {
        if (group == null || this.existsServiceGroup(group.getName())) {
            return;
        }
        this.groups.add(group);
    }

    @Override
    public ServiceGroup getServiceGroup(String name) {
        return this.groups.stream().filter(group -> group.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public List<ServiceGroup> getAllServiceGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public void createServiceGroup(String name, String platformName, String platformVersionName, int minOnlineCount, int maxOnlineCount, int maxPlayers, int maxMemory, boolean fallback, boolean isStatic, int startPriority, int startPercentage, String javaCommand, List<String> customJvmFlags, Map<String, Property<?>> propertyMap) {
        this.client.send(new GroupAddPacket(name, platformName, platformVersionName, minOnlineCount, maxOnlineCount, maxPlayers, maxMemory, fallback, isStatic, startPriority, startPercentage, javaCommand, customJvmFlags, propertyMap));
        ServiceGroupImpl group = new ServiceGroupImpl(name, platformName, platformVersionName, minOnlineCount, maxOnlineCount, maxPlayers, maxMemory, fallback, isStatic, startPriority, startPercentage, javaCommand, customJvmFlags, propertyMap);
        this.addServiceGroup(group);
    }

    @Override
    public void deleteServiceGroup(String name) {
        this.client.send(new GroupDeletePacket(name));
        this.deleteServiceGroupLocal(name);
    }

    public void deleteServiceGroupLocal(String name) {
        ServiceGroup group = this.getServiceGroup(name);
        if (group == null) {
            return;
        }
        this.groups.remove(group);
    }

    @Override
    public void updateServiceGroup(ServiceGroup group) {
        this.client.send(new GroupUpdatePacket(group.getName(), group.getMinOnlineCount(), group.getMaxOnlineCount(), group.getMaxPlayers(), group.getMaxMemory(), group.isFallback(), group.getStartPriority(), group.getStartPercentage(), group.getServiceTemplates(), group.getPropertyMap(), group.getCustomJvmFlags()));
    }

    @Override
    public boolean existsServiceGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        return this.groups.stream().anyMatch(group -> group != null && group.getName().equalsIgnoreCase(groupName));
    }
}

