/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.group.listeners;

import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.property.Property;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.PacketListener;
import net.potatocloud.core.networking.packets.group.GroupUpdatePacket;

public class GroupUpdateListener
implements PacketListener<GroupUpdatePacket> {
    private final ServiceGroupManager groupManager;

    @Override
    public void onPacket(NetworkConnection connection, GroupUpdatePacket packet) {
        ServiceGroup group = this.groupManager.getServiceGroup(packet.getGroupName());
        if (group == null) {
            return;
        }
        group.setMinOnlineCount(packet.getMinOnlineCount());
        group.setMaxOnlineCount(packet.getMaxOnlineCount());
        group.setMaxPlayers(packet.getMaxPlayers());
        group.setMaxMemory(packet.getMaxMemory());
        group.setFallback(packet.isFallback());
        group.setStartPriority(packet.getStartPriority());
        group.setStartPercentage(packet.getStartPercentage());
        group.getServiceTemplates().clear();
        packet.getServiceTemplates().forEach(group::addServiceTemplate);
        group.getCustomJvmFlags().clear();
        packet.getCustomJvmFlags().forEach(group::addCustomJvmFlag);
        group.getPropertyMap().clear();
        for (Property<?> property : packet.getPropertyMap().values()) {
            group.setProperty(property, property.getValue(), false);
        }
    }

    @Generated
    public GroupUpdateListener(ServiceGroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

