/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.platform;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.api.platform.impl.PlatformImpl;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.packets.platform.PlatformAddPacket;
import net.potatocloud.core.networking.packets.platform.PlatformUpdatePacket;
import net.potatocloud.core.networking.packets.platform.RequestPlatformsPacket;

public class PlatformManagerImpl
implements PlatformManager {
    private final NetworkClient client;
    private final List<Platform> platforms = new ArrayList<Platform>();

    public PlatformManagerImpl(NetworkClient client) {
        this.client = client;
        client.registerPacketListener(400, (connection, packet) -> this.platforms.add(packet.getPlatform()));
        client.registerPacketListener(401, (connection, packet) -> this.platforms.remove(this.getPlatform(packet.getPlatformName())));
        client.registerPacketListener(403, (connection, packet) -> {
            Platform platform = this.getPlatform(packet.getPlatform().getName());
            if (platform == null) {
                return;
            }
            platform.setVersions(packet.getPlatform().getVersions());
        });
        client.send(new RequestPlatformsPacket());
    }

    @Override
    public Platform createPlatform(String name, String downloadUrl, boolean custom, boolean isProxy, String base, String preCacheBuilder, String parser, String hashType, List<String> prepareSteps) {
        PlatformImpl platform = new PlatformImpl(name, downloadUrl, custom, isProxy, base, preCacheBuilder, parser, hashType, prepareSteps);
        this.platforms.add(platform);
        this.client.send(new PlatformAddPacket(platform));
        return platform;
    }

    @Override
    public void updatePlatform(Platform platform) {
        this.client.send(new PlatformUpdatePacket(platform));
    }

    @Generated
    public NetworkClient getClient() {
        return this.client;
    }

    @Override
    @Generated
    public List<Platform> getPlatforms() {
        return this.platforms;
    }
}

