/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.player;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.connector.event.ConnectPlayerWithServiceEvent;
import net.potatocloud.connector.player.listeners.CloudPlayerAddListener;
import net.potatocloud.connector.player.listeners.CloudPlayerRemoveListener;
import net.potatocloud.connector.player.listeners.CloudPlayerUpdateListener;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.packets.player.CloudPlayerAddPacket;
import net.potatocloud.core.networking.packets.player.CloudPlayerRemovePacket;
import net.potatocloud.core.networking.packets.player.CloudPlayerUpdatePacket;
import net.potatocloud.core.networking.packets.player.RequestCloudPlayersPacket;

public class CloudPlayerManagerImpl
implements CloudPlayerManager {
    private final Set<CloudPlayer> onlinePlayers = new HashSet<CloudPlayer>();
    private final NetworkClient client;

    public CloudPlayerManagerImpl(NetworkClient client) {
        this.client = client;
        client.send(new RequestCloudPlayersPacket());
        client.registerPacketListener(200, new CloudPlayerAddListener(this));
        client.registerPacketListener(201, new CloudPlayerRemoveListener(this));
        client.registerPacketListener(202, new CloudPlayerUpdateListener(this));
    }

    public void registerPlayer(CloudPlayer player) {
        if (this.onlinePlayers.contains(player)) {
            return;
        }
        this.registerPlayerLocal(player);
        this.client.send(new CloudPlayerAddPacket(player.getUsername(), player.getUniqueId(), player.getConnectedProxyName(), null));
    }

    public void registerPlayerLocal(CloudPlayer player) {
        if (this.onlinePlayers.contains(player)) {
            return;
        }
        this.onlinePlayers.add(player);
    }

    public void unregisterPlayer(CloudPlayer player) {
        if (!this.onlinePlayers.contains(player)) {
            return;
        }
        this.unregisterPlayerLocal(player);
        this.client.send(new CloudPlayerRemovePacket(player.getUniqueId()));
    }

    public void unregisterPlayerLocal(CloudPlayer player) {
        if (!this.onlinePlayers.contains(player)) {
            return;
        }
        this.onlinePlayers.remove(player);
    }

    @Override
    public CloudPlayer getCloudPlayer(String username) {
        return this.onlinePlayers.stream().filter(player -> player.getUsername().equals(username)).findFirst().orElse(null);
    }

    @Override
    public CloudPlayer getCloudPlayer(UUID uniqueId) {
        return this.onlinePlayers.stream().filter(player -> player.getUniqueId().equals(uniqueId)).findFirst().orElse(null);
    }

    @Override
    public Set<CloudPlayer> getOnlinePlayers() {
        return Collections.unmodifiableSet(this.onlinePlayers);
    }

    @Override
    public void connectPlayerWithService(String playerName, String serviceName) {
        CloudAPI.getInstance().getEventManager().call(new ConnectPlayerWithServiceEvent(playerName, serviceName));
    }

    @Override
    public void updatePlayer(CloudPlayer player) {
        this.client.send(new CloudPlayerUpdatePacket(player.getUniqueId(), player.getConnectedProxyName(), player.getConnectedServiceName(), player.getPropertyMap()));
    }

    @Generated
    public NetworkClient getClient() {
        return this.client;
    }
}

