/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.service;

import java.util.Map;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceStatus;
import net.potatocloud.connector.ConnectorAPI;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.packets.service.ServiceCopyPacket;
import net.potatocloud.core.networking.packets.service.ServiceExecuteCommandPacket;
import net.potatocloud.core.networking.packets.service.StopServicePacket;

public class ServiceImpl
implements Service {
    private final String name;
    private final int serviceId;
    private final int port;
    private final long startTimestamp;
    private final ServiceGroup group;
    private final Map<String, Property<?>> propertyMap;
    private ServiceStatus status;
    private int maxPlayers;
    private final NetworkClient client = ConnectorAPI.getInstance().getClient();

    @Override
    public int getUsedMemory() {
        return 0;
    }

    @Override
    public ServiceGroup getServiceGroup() {
        return this.group;
    }

    @Override
    public void shutdown() {
        this.client.send(new StopServicePacket(this.name));
    }

    @Override
    public boolean executeCommand(String command) {
        this.client.send(new ServiceExecuteCommandPacket(this.name, command));
        return false;
    }

    @Override
    public void copy(String template, String filter) {
        this.client.send(new ServiceCopyPacket(this.getName(), template, filter));
    }

    @Override
    public String getPropertyHolderName() {
        return this.getName();
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Generated
    public ServiceGroup getGroup() {
        return this.group;
    }

    @Override
    @Generated
    public Map<String, Property<?>> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    @Generated
    public ServiceStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Generated
    public NetworkClient getClient() {
        return this.client;
    }

    @Override
    @Generated
    public void setStatus(ServiceStatus status) {
        this.status = status;
    }

    @Override
    @Generated
    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    @Generated
    public ServiceImpl(String name, int serviceId, int port, long startTimestamp, ServiceGroup group, Map<String, Property<?>> propertyMap, ServiceStatus status, int maxPlayers) {
        this.name = name;
        this.serviceId = serviceId;
        this.port = port;
        this.startTimestamp = startTimestamp;
        this.group = group;
        this.propertyMap = propertyMap;
        this.status = status;
        this.maxPlayers = maxPlayers;
    }
}

