/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.connector.service;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.connector.service.listeners.ServiceAddListener;
import net.potatocloud.connector.service.listeners.ServiceUpdateListener;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.packets.service.RequestServicesPacket;
import net.potatocloud.core.networking.packets.service.ServiceUpdatePacket;
import net.potatocloud.core.networking.packets.service.StartServicePacket;

public class ServiceManagerImpl
implements ServiceManager {
    private final List<Service> services = new CopyOnWriteArrayList<Service>();
    private final NetworkClient client;

    public ServiceManagerImpl(NetworkClient client) {
        this.client = client;
        client.send(new RequestServicesPacket());
        client.registerPacketListener(0, new ServiceAddListener(this));
        client.registerPacketListener(1, (connection, packet) -> this.services.remove(this.getService(packet.getServiceName())));
        client.registerPacketListener(2, new ServiceUpdateListener(this));
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    @Override
    public Service getService(String serviceName) {
        return this.services.stream().filter(service -> service.getName().equalsIgnoreCase(serviceName)).findFirst().orElse(null);
    }

    @Override
    public List<Service> getAllServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public void updateService(Service service) {
        this.client.send(new ServiceUpdatePacket(service.getName(), service.getStatus().name(), service.getMaxPlayers(), service.getPropertyMap()));
    }

    @Override
    public void startService(String groupName) {
        this.client.send(new StartServicePacket(groupName));
    }

    @Override
    public void startServices(String groupName, int count) {
        for (int i = 0; i < count; ++i) {
            this.startService(groupName);
        }
    }

    @Override
    public Service getCurrentService() {
        return this.getService(System.getProperty("potatocloud.service.name"));
    }
}

