/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import lombok.Generated;
import net.potatocloud.core.networking.NetworkClient;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.PacketListener;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.PacketRegistry;
import net.potatocloud.core.networking.netty.NettyClientHandler;
import net.potatocloud.core.networking.netty.NettyNetworkConnection;
import net.potatocloud.core.networking.netty.NettyPacketDecoder;
import net.potatocloud.core.networking.netty.NettyPacketEncoder;

public class NettyNetworkClient
implements NetworkClient {
    private final PacketManager packetManager;
    private EventLoopGroup group;
    private Channel channel;
    private NetworkConnection connection;

    @Override
    public void connect(String host, int port) {
        PacketRegistry.registerPackets(this.packetManager);
        this.group = Epoll.isAvailable() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) {
                NettyNetworkClient.this.connection = new NettyNetworkConnection(channel);
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new NettyPacketDecoder(NettyNetworkClient.this.packetManager));
                pipeline.addLast(new NettyPacketEncoder());
                pipeline.addLast(new NettyClientHandler(NettyNetworkClient.this.packetManager, NettyNetworkClient.this.connection));
            }
        });
        ChannelFuture future = bootstrap.connect(host, port).syncUninterruptibly();
        this.channel = future.channel();
    }

    @Override
    public void send(Packet packet) {
        this.channel.writeAndFlush(packet);
    }

    @Override
    public void disconnect() {
        this.channel.close();
        this.group.shutdownGracefully();
    }

    @Override
    public <T extends Packet> void registerPacketListener(int id, PacketListener<T> listener) {
        this.packetManager.registerListener(id, listener);
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    @Generated
    public NettyNetworkClient(PacketManager packetManager) {
        this.packetManager = packetManager;
    }
}

