/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.PacketListener;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.PacketRegistry;
import net.potatocloud.core.networking.netty.NettyPacketDecoder;
import net.potatocloud.core.networking.netty.NettyPacketEncoder;
import net.potatocloud.core.networking.netty.NettyServerHandler;

public class NettyNetworkServer
implements NetworkServer {
    private final PacketManager packetManager;
    private final List<NetworkConnection> connectedSessions = new CopyOnWriteArrayList<NetworkConnection>();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel serverChannel;
    private int port;

    @Override
    public void start(String hostname, int port) {
        this.port = port;
        PacketRegistry.registerPackets(this.packetManager);
        IoHandlerFactory factory = Epoll.isAvailable() ? EpollIoHandler.newFactory() : NioIoHandler.newFactory();
        this.bossGroup = new MultiThreadIoEventLoopGroup(factory);
        this.workerGroup = new MultiThreadIoEventLoopGroup(factory);
        ServerBootstrap server = new ServerBootstrap();
        ((ServerBootstrap)server.group(this.bossGroup, this.workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.TCP_NODELAY, true).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new NettyPacketDecoder(NettyNetworkServer.this.packetManager));
                pipeline.addLast(new NettyPacketEncoder());
                pipeline.addLast(new NettyServerHandler(NettyNetworkServer.this, NettyNetworkServer.this.packetManager));
            }
        });
        ChannelFuture future = server.bind(new InetSocketAddress(hostname, port)).syncUninterruptibly();
        this.serverChannel = future.channel();
    }

    @Override
    public void shutdown() {
        for (NetworkConnection session : this.connectedSessions) {
            session.close();
        }
        this.serverChannel.close();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public boolean isRunning() {
        return this.serverChannel != null && this.serverChannel.isActive();
    }

    @Override
    public <T extends Packet> void registerPacketListener(int id, PacketListener<T> listener) {
        this.packetManager.registerListener(id, listener);
    }

    @Override
    public void sendToClient(NetworkConnection client, Packet packet) {
        client.send(packet);
    }

    @Generated
    public PacketManager getPacketManager() {
        return this.packetManager;
    }

    @Override
    @Generated
    public List<NetworkConnection> getConnectedSessions() {
        return this.connectedSessions;
    }

    @Generated
    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    @Generated
    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public Channel getServerChannel() {
        return this.serverChannel;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public NettyNetworkServer(PacketManager packetManager) {
        this.packetManager = packetManager;
    }
}

