/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import lombok.Generated;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.netty.NettyNetworkConnection;
import net.potatocloud.core.networking.netty.NettyNetworkServer;

public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    private final NettyNetworkServer server;
    private final PacketManager packetManager;

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.server.getConnectedSessions().add(new NettyNetworkConnection(ctx.channel()));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.server.getConnectedSessions().removeIf(session -> ((NettyNetworkConnection)session).getChannel().equals(ctx.channel()));
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Packet) {
            Packet packet = (Packet)msg;
            this.server.getConnectedSessions().stream().filter(conn -> {
                NettyNetworkConnection networkConnection;
                return conn instanceof NettyNetworkConnection && (networkConnection = (NettyNetworkConnection)conn).getChannel().equals(ctx.channel());
            }).findFirst().ifPresent(connection -> this.packetManager.onPacket((NetworkConnection)connection, packet));
        }
    }

    @Generated
    public NettyServerHandler(NettyNetworkServer server, PacketManager packetManager) {
        this.server = server;
        this.packetManager = packetManager;
    }
}

