/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.packets.player;

import java.util.UUID;
import lombok.Generated;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.netty.PacketBuffer;

public class CloudPlayerAddPacket
implements Packet {
    private String username;
    private UUID uniqueId;
    private String connectedProxyName;
    private String connectedServiceName;

    @Override
    public int getId() {
        return 200;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeString(this.username);
        buf.writeString(this.uniqueId.toString());
        buf.writeString(this.connectedProxyName);
        buf.writeString(this.connectedServiceName);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.username = buf.readString();
        this.uniqueId = UUID.fromString(buf.readString());
        this.connectedProxyName = buf.readString();
        this.connectedServiceName = buf.readString();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public String getConnectedProxyName() {
        return this.connectedProxyName;
    }

    @Generated
    public String getConnectedServiceName() {
        return this.connectedServiceName;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setConnectedProxyName(String connectedProxyName) {
        this.connectedProxyName = connectedProxyName;
    }

    @Generated
    public void setConnectedServiceName(String connectedServiceName) {
        this.connectedServiceName = connectedServiceName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudPlayerAddPacket)) {
            return false;
        }
        CloudPlayerAddPacket other = (CloudPlayerAddPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UUID this$uniqueId = this.getUniqueId();
        UUID other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
            return false;
        }
        String this$connectedProxyName = this.getConnectedProxyName();
        String other$connectedProxyName = other.getConnectedProxyName();
        if (this$connectedProxyName == null ? other$connectedProxyName != null : !this$connectedProxyName.equals(other$connectedProxyName)) {
            return false;
        }
        String this$connectedServiceName = this.getConnectedServiceName();
        String other$connectedServiceName = other.getConnectedServiceName();
        return !(this$connectedServiceName == null ? other$connectedServiceName != null : !this$connectedServiceName.equals(other$connectedServiceName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudPlayerAddPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UUID $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        String $connectedProxyName = this.getConnectedProxyName();
        result = result * 59 + ($connectedProxyName == null ? 43 : $connectedProxyName.hashCode());
        String $connectedServiceName = this.getConnectedServiceName();
        result = result * 59 + ($connectedServiceName == null ? 43 : $connectedServiceName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudPlayerAddPacket(username=" + this.getUsername() + ", uniqueId=" + String.valueOf(this.getUniqueId()) + ", connectedProxyName=" + this.getConnectedProxyName() + ", connectedServiceName=" + this.getConnectedServiceName() + ")";
    }

    @Generated
    public CloudPlayerAddPacket() {
    }

    @Generated
    public CloudPlayerAddPacket(String username, UUID uniqueId, String connectedProxyName, String connectedServiceName) {
        this.username = username;
        this.uniqueId = uniqueId;
        this.connectedProxyName = connectedProxyName;
        this.connectedServiceName = connectedServiceName;
    }
}

