/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.packets.player;

import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.potatocloud.api.property.Property;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.netty.PacketBuffer;

public class CloudPlayerUpdatePacket
implements Packet {
    private UUID playerUniqueId;
    private String connectedProxyName;
    private String connectedServiceName;
    private Map<String, Property<?>> propertyMap;

    @Override
    public int getId() {
        return 202;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeString(this.playerUniqueId.toString());
        buf.writeString(this.connectedProxyName);
        buf.writeString(this.connectedServiceName);
        buf.writePropertyMap(this.propertyMap);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.playerUniqueId = UUID.fromString(buf.readString());
        this.connectedProxyName = buf.readString();
        this.connectedServiceName = buf.readString();
        this.propertyMap = buf.readPropertyMap();
    }

    @Generated
    public UUID getPlayerUniqueId() {
        return this.playerUniqueId;
    }

    @Generated
    public String getConnectedProxyName() {
        return this.connectedProxyName;
    }

    @Generated
    public String getConnectedServiceName() {
        return this.connectedServiceName;
    }

    @Generated
    public Map<String, Property<?>> getPropertyMap() {
        return this.propertyMap;
    }

    @Generated
    public void setPlayerUniqueId(UUID playerUniqueId) {
        this.playerUniqueId = playerUniqueId;
    }

    @Generated
    public void setConnectedProxyName(String connectedProxyName) {
        this.connectedProxyName = connectedProxyName;
    }

    @Generated
    public void setConnectedServiceName(String connectedServiceName) {
        this.connectedServiceName = connectedServiceName;
    }

    @Generated
    public void setPropertyMap(Map<String, Property<?>> propertyMap) {
        this.propertyMap = propertyMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudPlayerUpdatePacket)) {
            return false;
        }
        CloudPlayerUpdatePacket other = (CloudPlayerUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$playerUniqueId = this.getPlayerUniqueId();
        UUID other$playerUniqueId = other.getPlayerUniqueId();
        if (this$playerUniqueId == null ? other$playerUniqueId != null : !((Object)this$playerUniqueId).equals(other$playerUniqueId)) {
            return false;
        }
        String this$connectedProxyName = this.getConnectedProxyName();
        String other$connectedProxyName = other.getConnectedProxyName();
        if (this$connectedProxyName == null ? other$connectedProxyName != null : !this$connectedProxyName.equals(other$connectedProxyName)) {
            return false;
        }
        String this$connectedServiceName = this.getConnectedServiceName();
        String other$connectedServiceName = other.getConnectedServiceName();
        if (this$connectedServiceName == null ? other$connectedServiceName != null : !this$connectedServiceName.equals(other$connectedServiceName)) {
            return false;
        }
        Map<String, Property<?>> this$propertyMap = this.getPropertyMap();
        Map<String, Property<?>> other$propertyMap = other.getPropertyMap();
        return !(this$propertyMap == null ? other$propertyMap != null : !((Object)this$propertyMap).equals(other$propertyMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudPlayerUpdatePacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $playerUniqueId = this.getPlayerUniqueId();
        result = result * 59 + ($playerUniqueId == null ? 43 : ((Object)$playerUniqueId).hashCode());
        String $connectedProxyName = this.getConnectedProxyName();
        result = result * 59 + ($connectedProxyName == null ? 43 : $connectedProxyName.hashCode());
        String $connectedServiceName = this.getConnectedServiceName();
        result = result * 59 + ($connectedServiceName == null ? 43 : $connectedServiceName.hashCode());
        Map<String, Property<?>> $propertyMap = this.getPropertyMap();
        result = result * 59 + ($propertyMap == null ? 43 : ((Object)$propertyMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudPlayerUpdatePacket(playerUniqueId=" + String.valueOf(this.getPlayerUniqueId()) + ", connectedProxyName=" + this.getConnectedProxyName() + ", connectedServiceName=" + this.getConnectedServiceName() + ", propertyMap=" + String.valueOf(this.getPropertyMap()) + ")";
    }

    @Generated
    public CloudPlayerUpdatePacket() {
    }

    @Generated
    public CloudPlayerUpdatePacket(UUID playerUniqueId, String connectedProxyName, String connectedServiceName, Map<String, Property<?>> propertyMap) {
        this.playerUniqueId = playerUniqueId;
        this.connectedProxyName = connectedProxyName;
        this.connectedServiceName = connectedServiceName;
        this.propertyMap = propertyMap;
    }
}

