/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.CommandInfo;
import net.potatocloud.node.command.SubCommand;

public abstract class Command {
    private final String name;
    private final String description;
    private final List<String> aliases;
    private final Set<SubCommand> subCommands;

    protected Command() {
        CommandInfo info = this.getClass().getAnnotation(CommandInfo.class);
        if (info == null) {
            throw new IllegalStateException("CommandInfo annotation missing in Command: " + this.getClass().getSimpleName());
        }
        this.name = info.name();
        this.description = info.description();
        this.aliases = Arrays.asList(info.aliases());
        this.subCommands = new HashSet<SubCommand>();
    }

    public abstract void execute(String[] var1);

    public SubCommand getSubCommand(String name) {
        return this.subCommands.stream().filter(subCommand -> subCommand.getName().equals(name)).findFirst().orElse(null);
    }

    public void addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
    }

    protected void sendHelp() {
        for (SubCommand subCommand : this.subCommands) {
            Node.getInstance().getLogger().info(subCommand.getUsage() + " &8- &7" + subCommand.getDescription());
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

