/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.node.command.Command;
import net.potatocloud.node.command.SubCommand;

public class CommandManager {
    private final Map<String, Command> commands = new HashMap<String, Command>();
    private final Map<String, Command> aliases = new HashMap<String, Command>();

    public void registerCommand(Command command) {
        this.commands.put(command.getName().toLowerCase(), command);
        command.getAliases().forEach(alias -> this.aliases.put(alias.toLowerCase(), command));
    }

    public void executeCommand(String line) {
        SubCommand subCommand;
        String[] args;
        if (line.isBlank()) {
            return;
        }
        String[] parts = line.trim().split(" ");
        String input = parts[0].toLowerCase();
        Command command = this.commands.get(input);
        if (command == null) {
            command = this.aliases.get(input);
        }
        if (command == null) {
            return;
        }
        String[] stringArray = args = parts.length > 1 ? Arrays.copyOfRange(parts, 1, parts.length) : new String[]{};
        if (!command.getSubCommands().isEmpty() && args.length > 0 && (subCommand = command.getSubCommand(args[0])) != null) {
            subCommand.execute(Arrays.copyOfRange(args, 1, args.length));
            return;
        }
        command.execute(args);
    }

    public Command getCommand(String name) {
        Command command = this.commands.get(name.toLowerCase());
        if (command != null) {
            return command;
        }
        return this.aliases.get(name);
    }

    public String[] getAllCommandNames() {
        ArrayList<String> names = new ArrayList<String>(this.commands.keySet());
        this.aliases.keySet().stream().filter(alias -> !names.contains(alias)).forEach(names::add);
        return names.toArray(new String[0]);
    }

    @Generated
    public Map<String, Command> getCommands() {
        return this.commands;
    }

    @Generated
    public Map<String, Command> getAliases() {
        return this.aliases;
    }
}

