/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands;

import lombok.Generated;
import net.potatocloud.api.utils.TimeFormatter;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.Command;
import net.potatocloud.node.command.CommandInfo;
import net.potatocloud.node.console.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;

@CommandInfo(name="info", description="Shows system and node info", aliases={"me"})
public class InfoCommand
extends Command {
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        SystemInfo info = new SystemInfo();
        GlobalMemory memory = info.getHardware().getMemory();
        CentralProcessor processor = info.getHardware().getProcessor();
        this.logger.info("OS&8: &a" + System.getProperty("os.name") + " &8(&a" + System.getProperty("os.version") + "&8, &a" + System.getProperty("os.arch") + "&8)");
        this.logger.info("User&8: &a" + System.getProperty("user.name"));
        this.logger.info("Java version&8: &a" + System.getProperty("java.version") + " &8(&a" + System.getProperty("java.vendor") + "&8)");
        this.logger.info("Uptime&8: &a" + TimeFormatter.formatAsDuration(Node.getInstance().getUptime()));
        this.logger.info("Started At&8: &a" + TimeFormatter.formatAsDateAndTime(Node.getInstance().getStartupTime()));
        double totalMemory = (double)memory.getTotal() / 1.073741824E9;
        double availableMemory = (double)memory.getAvailable() / 1.073741824E9;
        double usedMemory = totalMemory - availableMemory;
        this.logger.info("System Memory&8: &a" + String.format("%.2f", usedMemory) + " GB &8/ &a" + String.format("%.2f", totalMemory) + " GB");
        String cpuName = processor.getProcessorIdentifier().getName();
        int cores = processor.getPhysicalProcessorCount();
        int threads = processor.getLogicalProcessorCount();
        this.logger.info("CPU&8: &a" + cpuName + " &8(&a" + cores + " cores&8, &a" + threads + " threads&8)");
    }

    @Generated
    public InfoCommand(Logger logger) {
        this.logger = logger;
    }
}

