/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.group;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="info", description="Show details of the given service group", usage="group delete &8[&agroup&8]")
public class GroupInfoSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceGroupManager groupManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        ServiceGroup group = this.groupManager.getServiceGroup(name);
        if (group == null) {
            this.logger.info("&cNo service group found with the name &a" + name);
            return;
        }
        this.logger.info("&7Info for group &a" + group.getName() + "&8:");
        this.logger.info("&8\u00bb &7Platform: &a" + group.getPlatform().getName());
        this.logger.info("&8\u00bb &7Version: &a" + group.getPlatformVersion().getName());
        this.logger.info("&8\u00bb &7Templates: &a" + String.join((CharSequence)", ", group.getServiceTemplates()));
        this.logger.info("&8\u00bb &7Min Online Count: &a" + group.getMinOnlineCount());
        this.logger.info("&8\u00bb &7Max Online Count: &a" + group.getMaxOnlineCount());
        this.logger.info("&8\u00bb &7Online Players: &a" + CloudAPI.getInstance().getPlayerManager().getOnlinePlayersByGroup(group).size());
        this.logger.info("&8\u00bb &7Max Players: &a" + group.getMaxPlayers());
        this.logger.info("&8\u00bb &7Max Memory: &a" + group.getMaxMemory() + "MB");
        this.logger.info("&8\u00bb &7Fallback: " + (group.isFallback() ? "&aYes" : "&cNo"));
        this.logger.info("&8\u00bb &7Static: " + (group.isStatic() ? "&aYes" : "&cNo"));
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.groupManager.getAllServiceGroups().stream().map(ServiceGroup::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        return List.of();
    }

    @Generated
    public GroupInfoSubCommand(ServiceGroupManager groupManager, Logger logger) {
        this.groupManager = groupManager;
        this.logger = logger;
    }
}

