/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="copy", description="Copy files from the given service to the given template", usage="service copy &8[&aservice&8] &8[&atemplate8]")
public class ServiceCopySubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        String template = args[1];
        String filter = args.length >= 3 ? args[2] : "";
        if (filter.isEmpty()) {
            service.copy(template);
        } else {
            service.copy(template, filter);
        }
        this.logger.info("Copied &a" + (filter.isEmpty() ? "all service files" : filter) + " &7to template: &a" + template);
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        if (args.length == 2) {
            Service service = this.serviceManager.getService(args[0]);
            if (service == null) {
                return List.of();
            }
            return service.getServiceGroup().getServiceTemplates().stream().toList();
        }
        return List.of();
    }

    @Generated
    public ServiceCopySubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

