/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="edit", description="Edit the given service", usage="service edit &8[&akey&8] [&avalue&8]")
public class ServiceEditSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 3) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        String key = args[1].toLowerCase();
        String value = args[2];
        try {
            if (!key.equals("maxplayers")) {
                this.sendUsage();
                return;
            }
            service.setMaxPlayers(Integer.parseInt(value));
            service.update();
            this.logger.info("Updated &a" + key + " &7for service &a" + name + "&7 to &a" + value);
        }
        catch (NumberFormatException ex) {
            this.sendUsage();
        }
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        if (args.length == 2) {
            return Stream.of("maxPlayers").filter(key -> key.startsWith(args[1].toLowerCase())).toList();
        }
        return List.of();
    }

    @Generated
    public ServiceEditSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

