/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="execute", description="Execute a command on the given service", usage="service execute &8[&aservice&8]")
public class ServiceExecuteSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 2) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        if (!service.isOnline()) {
            this.logger.info("Service &a" + name + " &7is &coffline");
            return;
        }
        String commandToExecute = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (service.executeCommand(commandToExecute)) {
            this.logger.info("&7Executed command on service &a" + name + "&8: &7" + commandToExecute);
        } else {
            this.logger.info("&cFailed to execute command on service &a" + name);
        }
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        return List.of();
    }

    @Generated
    public ServiceExecuteSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

