/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="info", description="Show details of the given service", usage="service info &8[&aservice&8]")
public class ServiceInfoSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        this.logger.info("&7Info for service &a" + service.getName() + "&8:");
        this.logger.info("&8\u00bb &7Group: &a" + service.getServiceGroup().getName());
        this.logger.info("&8\u00bb &7Port: &a" + service.getPort());
        this.logger.info("&8\u00bb &7Status: &a" + String.valueOf((Object)service.getStatus()));
        this.logger.info("&8\u00bb &7Online Players: &a" + service.getOnlinePlayerCount());
        this.logger.info("&8\u00bb &7Max Players: &a" + service.getMaxPlayers());
        this.logger.info("&8\u00bb &7Memory usage: &a" + service.getUsedMemory() + "MB");
        this.logger.info("&8\u00bb &7Online Time: &a" + service.getFormattedUptime());
        this.logger.info("&8\u00bb &7Start Timestamp: &a" + service.getFormattedStartTimestamp());
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        return List.of();
    }

    @Generated
    public ServiceInfoSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

