/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.potatocloud.api.property.DefaultProperties;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.core.utils.PropertyUtil;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="property", description="Manage properties of the given service", usage="service property &8[&alist&8|&aset&8|&aremove&8] [&aservice&8] [&akey&8] [&avalue&8]")
public class ServicePropertySubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                if (args.length < 2) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                Service service = this.serviceManager.getService(name);
                if (service == null) {
                    this.logger.info("&cNo service found with the name &a" + name);
                    return;
                }
                List<Property<?>> properties = service.getProperties();
                if (properties.isEmpty()) {
                    this.logger.info("No properties found for service &a" + name);
                    return;
                }
                this.logger.info("Properties of service &a" + name + "&8:");
                for (Property<?> property : properties) {
                    this.logger.info("&8\u00bb &a" + property.getName() + " &7- " + String.valueOf(property.getValue()));
                }
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                Service service = this.serviceManager.getService(name);
                if (service == null) {
                    this.logger.info("&cNo service found with the name &a" + name);
                    return;
                }
                String key = args[2];
                Property property = service.getProperty(key);
                if (property == null) {
                    this.logger.info("Property &a" + key + "&7 was &cnot found &7in service &a" + name);
                    return;
                }
                service.getPropertyMap().remove(property.getName());
                service.update();
                this.logger.info("Property &a" + key + " &7was removed in service &a" + name);
                break;
            }
            case "set": {
                if (args.length < 4) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                Service service = this.serviceManager.getService(name);
                if (service == null) {
                    this.logger.info("&cNo service found with the name &a" + name);
                    return;
                }
                String key = args[2];
                String value = args[3];
                try {
                    Property<?> property = PropertyUtil.stringToProperty(key, value);
                    service.setProperty(property);
                    service.update();
                    this.logger.info("Property &a" + key + " &7was set to &a" + value + " &7in service &a" + name);
                }
                catch (Exception e) {
                    this.sendUsage();
                }
                break;
            }
            default: {
                this.sendUsage();
            }
        }
    }

    @Override
    public List<String> complete(String[] args) {
        String groupName;
        if (args.length == 1) {
            return Stream.of("list", "set", "remove").filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[1])).toList();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("remove") && this.serviceManager.getService(groupName = args[1]) != null) {
            return this.serviceManager.getService(groupName).getProperties().stream().map(Property::getName).filter(p -> p.startsWith(args[2])).toList();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("<custom>");
            completions.addAll(DefaultProperties.asSet().stream().map(Property::getName).filter(s -> s.startsWith(args[2].toLowerCase())).toList());
            return completions;
        }
        return List.of();
    }

    @Generated
    public ServicePropertySubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

