/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="start", description="Start new service(s)", usage="service start &8[&agroup&8] (&aamount&8)")
public class ServiceStartSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final ServiceGroupManager groupManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        ServiceGroup group = this.groupManager.getServiceGroup(name);
        if (group == null) {
            this.logger.info("&cNo service group found with the name &a" + name);
            return;
        }
        int amount = 1;
        if (args.length >= 3) {
            try {
                amount = Integer.parseInt(args[2]);
                if (amount <= 0) {
                    this.sendUsage();
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.sendUsage();
                return;
            }
        }
        this.serviceManager.startServices(group, amount);
        this.logger.info("&7Starting " + amount + " new service(s) of group &a" + group.getName());
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.groupManager.getAllServiceGroups().stream().map(ServiceGroup::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        return List.of();
    }

    @Generated
    public ServiceStartSubCommand(ServiceManager serviceManager, ServiceGroupManager groupManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.groupManager = groupManager;
        this.logger = logger;
    }
}

