/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="stop", description="Shutdown the given service", usage="service stop &8[&aservice&8]")
public class ServiceStopSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        service.shutdown();
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return this.serviceManager.getAllServices().stream().map(Service::getName).filter(name -> name.startsWith(args[0])).toList();
        }
        return List.of();
    }

    @Generated
    public ServiceStopSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

