/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.console;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.Command;
import net.potatocloud.node.command.CommandManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.setup.Setup;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleCompleter
implements Completer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleCompleter.class);
    private final CommandManager commandManager;

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        block15: {
            String currentWord;
            List<String> words;
            block14: {
                ScreenManager screenManager = Node.getInstance().getScreenManager();
                Screen currentScreen = screenManager.getCurrentScreen();
                if (currentScreen != null && !currentScreen.getName().equals("node_screen") && !currentScreen.getName().startsWith("setup_")) {
                    candidates.add(new Candidate("leave"));
                    candidates.add(new Candidate("exit"));
                    return;
                }
                Setup currentSetup = Node.getInstance().getSetupManager().getCurrentSetup();
                if (currentSetup != null) {
                    if (currentSetup.isInSummary()) {
                        candidates.add(new Candidate("back"));
                        candidates.add(new Candidate("confirm"));
                        candidates.add(new Candidate("cancel"));
                    } else {
                        candidates.add(new Candidate("back"));
                        candidates.add(new Candidate("cancel"));
                        List<String> possibleChoices = currentSetup.getQuestions().get(currentSetup.getCurrentIndex()).getPossibleChoices(currentSetup.getAnswers());
                        if (possibleChoices != null) {
                            for (String possibleChoice : possibleChoices) {
                                candidates.add(new Candidate(possibleChoice));
                            }
                        }
                    }
                    return;
                }
                words = line.words();
                currentWord = line.word();
                if (line.wordIndex() != 0) break block14;
                for (String cmd : this.commandManager.getAllCommandNames()) {
                    if (!cmd.startsWith(currentWord)) continue;
                    candidates.add(new Candidate(cmd));
                }
                break block15;
            }
            String commandName = words.getFirst();
            Command command = this.commandManager.getCommand(commandName);
            if (command == null) {
                return;
            }
            String[] args = words.subList(1, words.size()).toArray(new String[0]);
            if (!command.getSubCommands().isEmpty() && args.length > 0) {
                SubCommand subCommand = command.getSubCommand(args[0]);
                if (subCommand == null) {
                    for (SubCommand sub : command.getSubCommands()) {
                        if (!sub.getName().startsWith(args[0])) continue;
                        candidates.add(new Candidate(sub.getName()));
                    }
                    return;
                }
                if (subCommand instanceof TabCompleter) {
                    TabCompleter completer = (TabCompleter)((Object)subCommand);
                    for (String suggestion : completer.complete(Arrays.copyOfRange(args, 1, args.length))) {
                        if (!suggestion.startsWith(currentWord)) continue;
                        candidates.add(new Candidate(suggestion));
                    }
                }
                return;
            }
            if (!(command instanceof TabCompleter)) break block15;
            TabCompleter completer = (TabCompleter)((Object)command);
            for (String suggestion : completer.complete(args)) {
                if (!suggestion.startsWith(currentWord)) continue;
                candidates.add(new Candidate(suggestion));
            }
        }
    }

    @Generated
    public ConsoleCompleter(CommandManager commandManager) {
        this.commandManager = commandManager;
    }
}

