/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.console;

import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.CommandManager;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.setup.Setup;
import org.jline.jansi.Ansi;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public class ConsoleReader
extends Thread {
    private final Console console;
    private final CommandManager commandManager;
    private final Node node;

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                String input = this.console.getLineReader().readLine(this.console.getPrompt());
                Screen currentScreen = Node.getInstance().getScreenManager().getCurrentScreen();
                boolean isNodeScreen = currentScreen.getName().equals("node_screen");
                if (isNodeScreen && input.isBlank()) {
                    this.console.println(Ansi.ansi().cursorUpLine().eraseLine().cursorUp(1).toString());
                    continue;
                }
                if (isNodeScreen) {
                    this.node.getLogger().logCommand(input);
                    this.commandManager.executeCommand(input);
                    continue;
                }
                if (currentScreen.getName().contains("setup")) {
                    Setup currentSetup = Node.getInstance().getSetupManager().getCurrentSetup();
                    if (currentSetup == null) continue;
                    currentSetup.handleInput(input);
                    continue;
                }
                if (input.equalsIgnoreCase("leave") || input.equalsIgnoreCase("exit")) {
                    Node.getInstance().getScreenManager().switchScreen("node_screen");
                    continue;
                }
                Service service = this.node.getServiceManager().getService(currentScreen.getName());
                if (service == null) continue;
                service.executeCommand(input);
            }
        }
        catch (UserInterruptException e) {
            this.node.shutdown();
        }
        catch (EndOfFileException e) {
            this.console.clearScreen();
            this.console.updateScreen();
        }
    }

    @Generated
    public ConsoleReader(Console console, CommandManager commandManager, Node node) {
        this.console = console;
        this.commandManager = commandManager;
        this.node = node;
    }
}

