/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.group;

import java.nio.file.Path;
import java.util.HashMap;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.impl.ServiceGroupImpl;
import net.potatocloud.api.property.Property;
import org.simpleyaml.configuration.file.YamlFile;

public final class ServiceGroupStorage {
    public static void saveToFile(ServiceGroup group, Path directory) {
        YamlFile config = new YamlFile(directory.resolve(group.getName() + ".yml").toFile());
        config.set("name", group.getName());
        config.set("platform", group.getPlatform().getName() + "-" + group.getPlatformVersionName());
        config.set("templates", group.getServiceTemplates());
        config.set("minOnlineCount", group.getMinOnlineCount());
        config.set("maxOnlineCount", group.getMaxOnlineCount());
        config.set("maxPlayers", group.getMaxPlayers());
        config.set("maxMemory", group.getMaxMemory());
        config.set("fallback", group.isFallback());
        config.set("static", group.isStatic());
        config.set("startPriority", group.getStartPriority());
        config.set("startPercentage", group.getStartPercentage());
        config.set("javaCommand", group.getJavaCommand());
        if (!group.getCustomJvmFlags().isEmpty()) {
            config.set("customJvmFlags", group.getCustomJvmFlags());
        }
        if (!group.getProperties().isEmpty()) {
            for (Property<?> property : group.getProperties()) {
                config.set("properties." + property.getName() + ".value", property.getValue());
                config.set("properties." + property.getName() + ".default", property.getDefaultValue());
            }
        }
        config.save();
    }

    public static ServiceGroup loadFromFile(Path groupFile) {
        YamlFile config = new YamlFile(groupFile.toFile());
        config.load();
        HashMap properties = new HashMap();
        if (config.isSet("properties")) {
            for (String key : config.getConfigurationSection("properties").getKeys(false)) {
                Object value = config.get("properties." + key + ".value");
                Object defaultValue = config.get("properties." + key + ".default");
                if (defaultValue == null) {
                    defaultValue = value;
                }
                properties.put(key, Property.of(key, defaultValue, value));
            }
        }
        String platformFullName = config.getString("platform");
        String[] parts = platformFullName.split("-", 2);
        String platformName = parts[0];
        String platformVersion = parts[1];
        return new ServiceGroupImpl(config.getString("name"), platformName, platformVersion, config.getStringList("templates"), config.getInt("minOnlineCount"), config.getInt("maxOnlineCount"), config.getInt("maxPlayers"), config.getInt("maxMemory"), config.getBoolean("fallback"), config.getBoolean("static"), config.getInt("startPriority"), config.getInt("startPercentage"), config.getString("javaCommand"), config.getStringList("customJvmFlags"), properties);
    }

    @Generated
    private ServiceGroupStorage() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

