/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform;

import java.util.Collections;
import java.util.List;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.api.platform.impl.PlatformImpl;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.platform.PlatformAddPacket;
import net.potatocloud.core.networking.packets.platform.PlatformUpdatePacket;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.PlatformFileHandler;
import net.potatocloud.node.platform.listeners.PlatformAddListener;
import net.potatocloud.node.platform.listeners.PlatformUpdateListener;
import net.potatocloud.node.platform.listeners.RequestPlatformsListener;

public class PlatformManagerImpl
implements PlatformManager {
    private final Logger logger;
    private final NetworkServer server;
    private final PlatformFileHandler fileHandler;
    private final List<Platform> platforms;

    public PlatformManagerImpl(Logger logger, NetworkServer server) {
        this.logger = logger;
        this.server = server;
        this.fileHandler = new PlatformFileHandler(logger);
        this.platforms = this.fileHandler.loadPlatformsFile();
        server.registerPacketListener(402, new RequestPlatformsListener(this));
        server.registerPacketListener(403, new PlatformUpdateListener(this));
        server.registerPacketListener(400, new PlatformAddListener(this));
        logger.info("Loaded &a" + this.platforms.size() + " &7platforms");
    }

    @Override
    public List<Platform> getPlatforms() {
        return Collections.unmodifiableList(this.platforms);
    }

    @Override
    public Platform createPlatform(String name, String downloadUrl, boolean custom, boolean isProxy, String base, String preCacheBuilder, String parser, String hashType, List<String> prepareSteps) {
        PlatformImpl platform = new PlatformImpl(name, downloadUrl, custom, isProxy, base, preCacheBuilder, parser, hashType, prepareSteps);
        this.addPlatform(platform);
        this.server.broadcastPacket(new PlatformAddPacket(platform));
        this.logger.info("Platform &a" + name + " &7was successfully created");
        return platform;
    }

    @Override
    public void updatePlatform(Platform platform) {
        this.server.broadcastPacket(new PlatformUpdatePacket(platform));
        this.fileHandler.updatePlatform(platform);
    }

    public void addPlatform(Platform platform) {
        if (platform == null || this.exists(platform.getName())) {
            return;
        }
        this.platforms.add(platform);
        this.fileHandler.addPlatform(platform);
    }
}

