/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.cache;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.PlatformUtils;
import net.potatocloud.node.platform.cache.PaperPlatformPreCacheBuilder;
import net.potatocloud.node.platform.cache.PlatformPreCacheBuilder;
import net.potatocloud.node.utils.HashUtils;
import org.apache.commons.io.FileUtils;

public class CacheManager {
    private final Logger logger;
    private final Map<String, PlatformPreCacheBuilder> cacheBuilderMap = Map.of("paper", new PaperPlatformPreCacheBuilder());
    private final Set<String> runningCacheBuilders = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path preCachePlatform(ServiceGroup group) {
        Platform platform = group.getPlatform();
        PlatformVersion version = group.getPlatformVersion();
        PlatformPreCacheBuilder builder = this.getPreCacheBuilder(platform.getPreCacheBuilder());
        if (builder == null) {
            return null;
        }
        if (version.isLegacy() && builder instanceof PaperPlatformPreCacheBuilder) {
            return null;
        }
        Path platformFolder = PlatformUtils.getPlatformFolder(platform, version);
        File platformJarFile = PlatformUtils.getPlatformJarFile(platform, version);
        if (!platformJarFile.exists()) {
            return null;
        }
        String jarHash = HashUtils.sha256(platformJarFile);
        Path cacheFolder = platformFolder.resolve("cache-" + jarHash);
        String key = platform.getName() + "-" + version.getName() + "-" + jarHash;
        if (cacheFolder.toFile().exists()) {
            return cacheFolder;
        }
        if (!this.runningCacheBuilders.add(key)) {
            return null;
        }
        try {
            for (File file : platformFolder.toFile().listFiles()) {
                if (!file.isDirectory() || !file.getName().startsWith("cache-")) continue;
                FileUtils.deleteDirectory(file);
            }
            this.logger.info("Started caching for &a" + platform.getName() + "&7 version &a" + version.getName());
            cacheFolder.toFile().mkdirs();
            builder.buildCache(platform, version, group, cacheFolder);
            this.logger.info("Finished caching for &a" + platform.getName() + "&7 version &a" + version.getName());
        }
        catch (Exception e) {
            this.logger.error("Caching failed for version " + version.getFullName());
        }
        finally {
            this.runningCacheBuilders.remove(key);
        }
        return cacheFolder;
    }

    public void copyCacheToService(ServiceGroup group, Path cacheFolder, Path serviceDir) {
        PlatformPreCacheBuilder builder = this.getPreCacheBuilder(group.getPlatform().getPreCacheBuilder());
        if (builder != null) {
            builder.copyCacheToService(cacheFolder, serviceDir);
        }
    }

    private PlatformPreCacheBuilder getPreCacheBuilder(String name) {
        if (name == null) {
            return null;
        }
        return this.cacheBuilderMap.get(name.toLowerCase());
    }

    @Generated
    public CacheManager(Logger logger) {
        this.logger = logger;
    }
}

