/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.cache;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.node.platform.PlatformUtils;
import net.potatocloud.node.platform.cache.PlatformPreCacheBuilder;
import org.apache.commons.io.FileUtils;

public class PaperPlatformPreCacheBuilder
implements PlatformPreCacheBuilder {
    @Override
    public void buildCache(Platform platform, PlatformVersion version, ServiceGroup group, Path cacheFolder) {
        Path generatedVersions;
        Path generatedLibraries;
        File platformJarFile = PlatformUtils.getPlatformJarFile(platform, version);
        Path tempDir = cacheFolder.resolve("temp");
        tempDir.toFile().mkdirs();
        ArrayList<String> args = new ArrayList<String>();
        args.add(group.getJavaCommand());
        args.add("-Dpaperclip.patchonly=true");
        args.add("-jar");
        args.add(platformJarFile.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(tempDir.toFile());
        Process process = processBuilder.start();
        process.waitFor();
        Path generatedCache = tempDir.resolve("cache");
        if (Files.exists(generatedCache, new LinkOption[0])) {
            FileUtils.copyDirectory(generatedCache.toFile(), cacheFolder.resolve("cache").toFile());
        }
        if (Files.exists(generatedLibraries = tempDir.resolve("libraries"), new LinkOption[0])) {
            FileUtils.copyDirectory(generatedLibraries.toFile(), cacheFolder.resolve("libraries").toFile());
        }
        if (Files.exists(generatedVersions = tempDir.resolve("versions"), new LinkOption[0])) {
            FileUtils.copyDirectory(generatedVersions.toFile(), cacheFolder.resolve("versions").toFile());
        }
        FileUtils.deleteDirectory(tempDir.toFile());
    }

    @Override
    public void copyCacheToService(Path cacheFolder, Path serviceDir) {
        Path cachedVersions;
        Path cachedLibraries;
        if (cacheFolder == null) {
            return;
        }
        Path cachedCache = cacheFolder.resolve("cache");
        if (Files.exists(cachedCache, new LinkOption[0])) {
            FileUtils.copyDirectory(cachedCache.toFile(), serviceDir.resolve("cache").toFile());
        }
        if (Files.exists(cachedLibraries = cacheFolder.resolve("libraries"), new LinkOption[0])) {
            FileUtils.copyDirectory(cachedLibraries.toFile(), serviceDir.resolve("libraries").toFile());
        }
        if (Files.exists(cachedVersions = cacheFolder.resolve("versions"), new LinkOption[0])) {
            FileUtils.copyDirectory(cachedVersions.toFile(), serviceDir.resolve("versions").toFile());
        }
    }
}

