/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import lombok.Generated;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.platform.impl.PlatformVersionImpl;
import net.potatocloud.api.utils.RequestUtil;
import net.potatocloud.node.platform.BuildParser;

public class PaperBuildParser
implements BuildParser {
    private final String projectName;

    @Override
    public String getName() {
        return this.projectName;
    }

    @Override
    public void parse(PlatformVersion version, String baseUrl) {
        try {
            String mcVersion = version.getName();
            if (mcVersion.equalsIgnoreCase("latest")) {
                JsonArray versions = RequestUtil.request("https://api.papermc.io/v2/projects/" + this.projectName).getAsJsonArray("versions");
                mcVersion = versions.get(versions.size() - 1).getAsString();
            }
            JsonArray builds = RequestUtil.request("https://api.papermc.io/v2/projects/" + this.projectName + "/versions/" + mcVersion).getAsJsonArray("builds");
            int latestBuild = builds.get(builds.size() - 1).getAsInt();
            JsonObject buildJson = RequestUtil.request("https://api.papermc.io/v2/projects/" + this.projectName + "/versions/" + mcVersion + "/builds/" + latestBuild);
            JsonObject application = buildJson.getAsJsonObject("downloads").getAsJsonObject("application");
            String sha256 = application.get("sha256").getAsString();
            String downloadUrl = baseUrl.replace("{version}", mcVersion).replace("{build}", String.valueOf(latestBuild)).replace("{sha256}", sha256);
            if (version instanceof PlatformVersionImpl) {
                PlatformVersionImpl impl = (PlatformVersionImpl)version;
                impl.setFileHash(sha256);
                impl.setDownloadUrl(downloadUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public PaperBuildParser(String projectName) {
        this.projectName = projectName;
    }
}

