/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.steps;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PrepareStep;
import net.potatocloud.api.service.Service;
import net.potatocloud.node.Node;
import net.potatocloud.node.config.NodeConfig;
import net.potatocloud.node.utils.ProxyUtils;

public class DefaultFilesStep
implements PrepareStep {
    @Override
    public void execute(Service service, Platform platform, Path serverDirectory) {
        Path serverProperties;
        Path velocityToml;
        NodeConfig config = Node.getInstance().getConfig();
        if (platform.isBukkitBased()) {
            Path paperYml;
            Path spigotYml;
            Path serverProperties2 = serverDirectory.resolve("server.properties");
            if (!serverProperties2.toFile().exists()) {
                Files.copy(Path.of(config.getDataFolder(), "server.properties"), serverProperties2, new CopyOption[0]);
            }
            if (!ProxyUtils.isProxyModernForwarding() && !Files.exists(spigotYml = serverDirectory.resolve("spigot.yml"), new LinkOption[0])) {
                Files.copy(Path.of(config.getDataFolder(), "spigot.yml"), spigotYml, new CopyOption[0]);
            }
            if (platform.isPaperBased() && ProxyUtils.isProxyModernForwarding() && !Files.exists(paperYml = serverDirectory.resolve("config").resolve("paper-global.yml"), new LinkOption[0])) {
                Files.createDirectories(paperYml.getParent(), new FileAttribute[0]);
                Files.copy(Path.of(config.getDataFolder(), "paper-global.yml"), paperYml, new CopyOption[0]);
            }
            return;
        }
        if (platform.isVelocityBased() && !Files.exists(velocityToml = serverDirectory.resolve("velocity.toml"), new LinkOption[0])) {
            Files.copy(Path.of(config.getDataFolder(), "velocity.toml"), velocityToml, new CopyOption[0]);
            return;
        }
        if (platform.isLimboBased() && !Files.exists(serverProperties = serverDirectory.resolve("server.properties"), new LinkOption[0])) {
            Files.copy(Path.of(config.getDataFolder(), "limbo-server.properties"), serverProperties, new CopyOption[0]);
        }
    }

    @Override
    public String getName() {
        return "default-files";
    }
}

