/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.steps;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PrepareStep;
import net.potatocloud.api.service.Service;
import net.potatocloud.node.utils.PropertiesFileUtils;

public class PortStep
implements PrepareStep {
    @Override
    public void execute(Service service, Platform platform, Path serverDirectory) {
        if (platform.isBukkitBased()) {
            Path propertiesPath = serverDirectory.resolve("server.properties");
            Properties properties = PropertiesFileUtils.loadProperties(propertiesPath);
            properties.setProperty("server-port", String.valueOf(service.getPort()));
            properties.setProperty("query.port", String.valueOf(service.getPort()));
            PropertiesFileUtils.saveProperties(properties, propertiesPath);
            return;
        }
        if (platform.isProxy() && platform.isVelocityBased()) {
            Path velocityToml = serverDirectory.resolve("velocity.toml");
            String fileContent = Files.readString(velocityToml);
            fileContent = fileContent.replace("bind = \"0.0.0.0:25565\"", "bind = \"0.0.0.0:" + service.getPort() + "\"");
            Files.writeString(velocityToml, (CharSequence)fileContent, new OpenOption[0]);
        }
        if (platform.isLimboBased()) {
            Path propertiesPath = serverDirectory.resolve("server.properties");
            Properties properties = PropertiesFileUtils.loadProperties(propertiesPath);
            properties.setProperty("server-port", String.valueOf(service.getPort()));
            PropertiesFileUtils.saveProperties(properties, propertiesPath);
        }
    }

    @Override
    public String getName() {
        return "port";
    }
}

