/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.steps;

import java.nio.file.Path;
import java.util.Properties;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PrepareStep;
import net.potatocloud.api.service.Service;
import net.potatocloud.node.platform.VelocityForwardingSecret;
import net.potatocloud.node.utils.PropertiesFileUtils;
import net.potatocloud.node.utils.ProxyUtils;
import org.simpleyaml.configuration.file.YamlFile;

public class SetupProxyStep
implements PrepareStep {
    @Override
    public void execute(Service service, Platform platform, Path serverDirectory) {
        if (platform.isBukkitBased() && !ProxyUtils.isProxyModernForwarding()) {
            return;
        }
        if (platform.isPaperBased() && ProxyUtils.isProxyModernForwarding()) {
            Path paperYml = serverDirectory.resolve("config").resolve("paper-global.yml");
            YamlFile yaml = new YamlFile(paperYml.toFile());
            yaml.load();
            yaml.set("proxies.velocity.enabled", true);
            yaml.set("proxies.velocity.secret", VelocityForwardingSecret.FORWARDING_SECRET);
            yaml.save();
            return;
        }
        if (platform.isLimboBased()) {
            Path propertiesPath = serverDirectory.resolve("server.properties");
            Properties properties = PropertiesFileUtils.loadProperties(propertiesPath);
            if (!ProxyUtils.isProxyModernForwarding()) {
                properties.setProperty("bungeecord", "true");
            } else {
                properties.setProperty("forwarding-secrets", VelocityForwardingSecret.FORWARDING_SECRET);
                properties.setProperty("velocity-modern", "true");
            }
            PropertiesFileUtils.saveProperties(properties, propertiesPath);
        }
    }

    @Override
    public String getName() {
        return "setup-proxy";
    }
}

