/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.player;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.player.CloudPlayerConnectPacket;
import net.potatocloud.node.player.listeners.CloudPlayerAddListener;
import net.potatocloud.node.player.listeners.CloudPlayerRemoveListener;
import net.potatocloud.node.player.listeners.CloudPlayerUpdateListener;
import net.potatocloud.node.player.listeners.RequestCloudPlayersListener;

public class CloudPlayerManagerImpl
implements CloudPlayerManager {
    private final Set<CloudPlayer> onlinePlayers = new HashSet<CloudPlayer>();
    private final NetworkServer server;

    public CloudPlayerManagerImpl(NetworkServer server) {
        this.server = server;
        server.registerPacketListener(200, new CloudPlayerAddListener(this));
        server.registerPacketListener(201, new CloudPlayerRemoveListener(this));
        server.registerPacketListener(202, new CloudPlayerUpdateListener(this));
        server.registerPacketListener(204, new RequestCloudPlayersListener(this));
    }

    public void registerPlayer(CloudPlayer player) {
        this.onlinePlayers.add(player);
    }

    public void unregisterPlayer(CloudPlayer player) {
        this.onlinePlayers.remove(player);
    }

    @Override
    public CloudPlayer getCloudPlayer(String username) {
        return this.onlinePlayers.stream().filter(player -> player.getUsername().equals(username)).findFirst().orElse(null);
    }

    @Override
    public CloudPlayer getCloudPlayer(UUID uniqueId) {
        return this.onlinePlayers.stream().filter(player -> player.getUniqueId().equals(uniqueId)).findFirst().orElse(null);
    }

    @Override
    public Set<CloudPlayer> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    @Override
    public void connectPlayerWithService(String playerName, String serviceName) {
        this.server.broadcastPacket(new CloudPlayerConnectPacket(playerName, serviceName));
    }

    @Override
    public void updatePlayer(CloudPlayer player) {
    }
}

