/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.player.listeners;

import lombok.Generated;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.PacketListener;
import net.potatocloud.core.networking.packets.player.CloudPlayerRemovePacket;
import net.potatocloud.node.Node;
import net.potatocloud.node.player.CloudPlayerManagerImpl;

public class CloudPlayerRemoveListener
implements PacketListener<CloudPlayerRemovePacket> {
    private final CloudPlayerManagerImpl playerManager;

    @Override
    public void onPacket(NetworkConnection connection, CloudPlayerRemovePacket packet) {
        CloudPlayer player = this.playerManager.getCloudPlayer(packet.getPlayerUniqueId());
        if (player == null) {
            return;
        }
        this.playerManager.unregisterPlayer(player);
        Node node = Node.getInstance();
        node.getServer().getConnectedSessions().stream().filter(networkConnection -> !networkConnection.equals(connection)).forEach(networkConnection -> networkConnection.send(packet));
        if (node.getConfig().isLogPlayerConnections() && !node.isStopping()) {
            node.getLogger().info("Player &a" + player.getUsername() + " &7disconnected &7from the network &8[&7UUID&8: &a" + String.valueOf(player.getUniqueId()) + "&8]");
        }
    }

    @Generated
    public CloudPlayerRemoveListener(CloudPlayerManagerImpl playerManager) {
        this.playerManager = playerManager;
    }
}

