/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.player.listeners;

import lombok.Generated;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.api.player.impl.CloudPlayerImpl;
import net.potatocloud.api.property.Property;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.PacketListener;
import net.potatocloud.core.networking.packets.player.CloudPlayerUpdatePacket;
import net.potatocloud.node.Node;

public class CloudPlayerUpdateListener
implements PacketListener<CloudPlayerUpdatePacket> {
    private final CloudPlayerManager playerManager;

    @Override
    public void onPacket(NetworkConnection connection, CloudPlayerUpdatePacket packet) {
        CloudPlayerImpl player = (CloudPlayerImpl)this.playerManager.getCloudPlayer(packet.getPlayerUniqueId());
        if (player == null) {
            return;
        }
        player.setConnectedProxyName(packet.getConnectedProxyName());
        player.setConnectedServiceName(packet.getConnectedServiceName());
        player.getPropertyMap().clear();
        for (Property<?> property : packet.getPropertyMap().values()) {
            player.setProperty(property, property.getValue(), false);
        }
        Node.getInstance().getServer().getConnectedSessions().stream().filter(networkConnection -> !networkConnection.equals(connection)).forEach(networkConnection -> networkConnection.send(packet));
    }

    @Generated
    public CloudPlayerUpdateListener(CloudPlayerManager playerManager) {
        this.playerManager = playerManager;
    }
}

