/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.screen;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.screen.Screen;

public class ScreenManager {
    private final Console console;
    private final Logger logger;
    private Screen currentScreen = null;
    private final List<Screen> screens = new ArrayList<Screen>();

    public void switchScreen(String screenName, boolean updatePrompt) {
        Screen screen = this.getScreen(screenName);
        if (screen == null) {
            return;
        }
        this.currentScreen = screen;
        this.console.clearScreen();
        if (screen.getName().equals("node_screen")) {
            this.logger.getCachedLogs().stream().filter(log -> !log.toLowerCase().contains("service screen")).forEach(this.console::println);
            this.console.setPrompt(this.console.getDefaultPrompt());
            return;
        }
        if (updatePrompt) {
            this.console.setPrompt("[" + screen.getName() + "] ");
        }
        screen.getCachedLogs().forEach(this.console::println);
    }

    public void switchScreen(String screenName) {
        this.switchScreen(screenName, true);
    }

    public Screen getScreen(String screenName) {
        return this.screens.stream().filter(screen -> screen.getName().equalsIgnoreCase(screenName)).findFirst().orElse(null);
    }

    public void addScreen(Screen screen) {
        this.screens.add(screen);
    }

    public void removeScreen(Screen screen) {
        this.screens.remove(screen);
    }

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    @Generated
    public List<Screen> getScreens() {
        return this.screens;
    }

    @Generated
    public void setCurrentScreen(Screen currentScreen) {
        this.currentScreen = currentScreen;
    }

    @Generated
    public ScreenManager(Console console, Logger logger) {
        this.console = console;
        this.logger = logger;
    }
}

