/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.potatocloud.api.event.EventManager;
import net.potatocloud.api.event.events.service.PreparedServiceStartingEvent;
import net.potatocloud.api.event.events.service.ServiceStoppedEvent;
import net.potatocloud.api.event.events.service.ServiceStoppingEvent;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.api.service.ServiceStatus;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.service.ServiceRemovePacket;
import net.potatocloud.node.config.NodeConfig;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.DownloadManager;
import net.potatocloud.node.platform.PlatformManagerImpl;
import net.potatocloud.node.platform.PlatformPrepareSteps;
import net.potatocloud.node.platform.PlatformUtils;
import net.potatocloud.node.platform.cache.CacheManager;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.service.ServiceManagerImpl;
import net.potatocloud.node.service.ServicePerformanceFlags;
import net.potatocloud.node.service.ServiceProcessChecker;
import net.potatocloud.node.template.TemplateManager;
import org.apache.commons.io.FileUtils;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;

public class ServiceImpl
implements Service {
    private final int serviceId;
    private final int port;
    private final ServiceGroup serviceGroup;
    private final NodeConfig config;
    private final Logger logger;
    private final List<String> logs = new ArrayList<String>();
    private final NetworkServer server;
    private final ScreenManager screenManager;
    private final TemplateManager templateManager;
    private final PlatformManagerImpl platformManager;
    private final DownloadManager downloadManager;
    private final CacheManager cacheManager;
    private final EventManager eventManager;
    private final ServiceManager serviceManager;
    private final Console console;
    private final Map<String, Property<?>> propertyMap;
    private final Screen screen;
    private int maxPlayers;
    private ServiceStatus status = ServiceStatus.STOPPED;
    private long startTimestamp;
    private Path directory;
    private Process serverProcess;
    private BufferedWriter processWriter;
    private BufferedReader processReader;
    private ServiceProcessChecker processChecker;

    public ServiceImpl(int serviceId, int port, ServiceGroup serviceGroup, NodeConfig config, Logger logger, NetworkServer server, ScreenManager screenManager, TemplateManager templateManager, PlatformManagerImpl platformManager, DownloadManager downloadManager, CacheManager cacheManager, EventManager eventManager, ServiceManager serviceManager, Console console) {
        this.serviceId = serviceId;
        this.port = port;
        this.serviceGroup = serviceGroup;
        this.config = config;
        this.logger = logger;
        this.server = server;
        this.screenManager = screenManager;
        this.templateManager = templateManager;
        this.platformManager = platformManager;
        this.downloadManager = downloadManager;
        this.cacheManager = cacheManager;
        this.eventManager = eventManager;
        this.serviceManager = serviceManager;
        this.console = console;
        this.maxPlayers = serviceGroup.getMaxPlayers();
        this.propertyMap = new HashMap(serviceGroup.getPropertyMap());
        this.screen = new Screen(this.getName());
        screenManager.addScreen(this.screen);
    }

    @Override
    public String getName() {
        return this.serviceGroup.getName() + this.config.getSplitter() + this.serviceId;
    }

    @Override
    public int getUsedMemory() {
        if (this.serverProcess == null || !this.serverProcess.isAlive()) {
            return 0;
        }
        SystemInfo info = new SystemInfo();
        OSProcess process = info.getOperatingSystem().getProcess((int)this.serverProcess.pid());
        if (process != null) {
            long usedBytes = process.getResidentSetSize();
            return (int)(usedBytes / 1024L / 1024L);
        }
        return 0;
    }

    public void start() {
        if (this.isOnline()) {
            return;
        }
        this.status = ServiceStatus.STARTING;
        this.startTimestamp = System.currentTimeMillis();
        Path staticFolder = Path.of(this.config.getStaticFolder(), new String[0]);
        Path tempFolder = Path.of(this.config.getTempServicesFolder(), new String[0]);
        Path path = this.directory = this.serviceGroup.isStatic() ? staticFolder.resolve(this.getName()) : tempFolder.resolve(this.getName());
        if (!this.serviceGroup.isStatic() && Files.exists(this.directory, new LinkOption[0])) {
            FileUtils.deleteQuietly(this.directory.toFile());
        }
        Files.createDirectories(this.directory, new FileAttribute[0]);
        for (String templateName : this.serviceGroup.getServiceTemplates()) {
            this.templateManager.copyTemplate(templateName, this.directory);
        }
        Path pluginsFolder = this.directory.resolve("plugins");
        Files.createDirectories(pluginsFolder, new FileAttribute[0]);
        String pluginName = "";
        if (this.serviceGroup.getPlatform().isBukkitBased()) {
            pluginName = "potatocloud-plugin-spigot.jar";
        } else if (this.serviceGroup.getPlatform().isVelocityBased()) {
            pluginName = "potatocloud-plugin-velocity.jar";
        } else if (this.serviceGroup.getPlatform().isLimboBased()) {
            pluginName = "potatocloud-plugin-limbo.jar";
        }
        FileUtils.copyFile(Path.of(this.config.getDataFolder(), pluginName).toFile(), pluginsFolder.resolve(pluginName).toFile(), StandardCopyOption.REPLACE_EXISTING);
        Platform platform = this.serviceGroup.getPlatform();
        PlatformVersion version = this.serviceGroup.getPlatformVersion();
        this.downloadManager.downloadPlatformVersion(platform, platform.getVersion(this.serviceGroup.getPlatformVersionName()));
        Path cacheFolder = this.cacheManager.preCachePlatform(this.serviceGroup);
        this.cacheManager.copyCacheToService(this.serviceGroup, cacheFolder, this.directory);
        File platformFile = PlatformUtils.getPlatformJarFile(platform, version);
        Path finalServerFilePath = this.directory.resolve("server.jar");
        FileUtils.copyFile(platformFile, finalServerFilePath.toFile());
        for (String step : platform.getPrepareSteps()) {
            PlatformPrepareSteps.getStep(step).execute(this, platform, this.directory);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.serviceGroup.getJavaCommand());
        args.add("-Xms" + this.serviceGroup.getMaxMemory() + "M");
        args.add("-Xmx" + this.serviceGroup.getMaxMemory() + "M");
        args.add("-Dpotatocloud.service.name=" + this.getName());
        args.add("-Dpotatocloud.node.port=" + this.config.getNodePort());
        args.addAll(ServicePerformanceFlags.DEFAULT_FLAGS);
        if (this.serviceGroup.getCustomJvmFlags() != null) {
            args.addAll(this.serviceGroup.getCustomJvmFlags());
        }
        args.add("-jar");
        args.add(finalServerFilePath.toAbsolutePath().toString());
        if (platform.isBukkitBased() && !version.isLegacy()) {
            args.add("-nogui");
        }
        if (platform.isLimboBased()) {
            args.add("--nogui");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(this.directory.toFile());
        this.serverProcess = processBuilder.start();
        this.processWriter = new BufferedWriter(new OutputStreamWriter(this.serverProcess.getOutputStream()));
        this.processReader = new BufferedReader(new InputStreamReader(this.serverProcess.getInputStream()));
        new Thread(() -> {
            try {
                String line;
                while ((line = this.processReader.readLine()) != null) {
                    this.logs.add(line);
                    this.screen.addLog(line);
                    if (!this.screenManager.getCurrentScreen().getName().equals(this.getName())) continue;
                    this.console.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "ProcessReader-" + this.getName()).start();
        this.logger.info("Service &a" + this.getName() + "&7 is now starting&8... &8[&7Port&8: &a" + this.port + "&8, &7Group&8: &a" + this.serviceGroup.getName() + "&8]");
        this.eventManager.call(new PreparedServiceStartingEvent(this.getName()));
    }

    @Override
    public void shutdown() {
        if (this.status == ServiceStatus.STOPPED || this.status == ServiceStatus.STOPPING) {
            return;
        }
        new Thread(this::shutdownBlocking, "Shutdown-" + this.getName()).start();
    }

    public void shutdownBlocking() {
        Platform platform;
        if (this.status == ServiceStatus.STOPPED || this.status == ServiceStatus.STOPPING) {
            return;
        }
        if (this.processChecker != null) {
            this.processChecker.interrupt();
            this.processChecker = null;
        }
        this.logger.info("Stopping service &a" + this.getName() + "&7...");
        this.status = ServiceStatus.STOPPING;
        if (this.server != null && this.eventManager != null) {
            this.eventManager.call(new ServiceStoppingEvent(this.getName()));
        }
        this.executeCommand((platform = this.platformManager.getPlatform(this.serviceGroup.getPlatformName())).isProxy() ? "end" : "stop");
        if (this.processWriter != null) {
            this.processWriter.close();
            this.processWriter = null;
        }
        if (this.serverProcess != null) {
            boolean finished = this.serverProcess.waitFor(10L, TimeUnit.SECONDS);
            if (!finished) {
                this.serverProcess.toHandle().destroyForcibly();
                this.serverProcess.waitFor();
            }
            this.serverProcess = null;
        }
        this.cleanup();
    }

    public void cleanup() {
        if (this.status == ServiceStatus.STOPPED) {
            return;
        }
        this.status = ServiceStatus.STOPPED;
        this.startTimestamp = 0L;
        ((ServiceManagerImpl)this.serviceManager).removeService(this);
        this.screenManager.removeScreen(this.screen);
        if (this.screenManager.getCurrentScreen().getName().equals(this.getName())) {
            this.screenManager.switchScreen("node_screen");
        }
        if (this.server != null) {
            this.server.broadcastPacket(new ServiceRemovePacket(this.getName(), this.getPort()));
            this.eventManager.call(new ServiceStoppedEvent(this.getName()));
        }
        if (!this.serviceGroup.isStatic() && Files.exists(this.directory, new LinkOption[0]) && !FileUtils.deleteQuietly(this.directory.toFile())) {
            this.logger.error("Temp directory for " + this.getName() + " could not be deleted! The service might still be running");
        }
        this.logger.info("Service &a" + this.getName() + " &7has been stopped");
    }

    @Override
    public boolean executeCommand(String command) {
        if (this.serverProcess == null || !this.serverProcess.isAlive() || this.processWriter == null) {
            return false;
        }
        this.processWriter.write(command);
        this.processWriter.newLine();
        this.processWriter.flush();
        return true;
    }

    @Override
    public void copy(String template, String filter) {
        Path templatesFolder = Path.of(this.config.getTemplatesFolder(), new String[0]);
        Path targetPath = templatesFolder.resolve(template);
        Path sourcePath = this.directory;
        if (filter != null && filter.startsWith("/")) {
            sourcePath = this.directory.resolve(filter.substring(1));
            targetPath = targetPath.resolve(filter.substring(1));
        }
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(targetPath, new LinkOption[0])) {
            this.templateManager.createTemplate(targetPath.toFile().getName());
        }
        try {
            FileUtils.copyDirectory(sourcePath.toFile(), targetPath.toFile());
        }
        catch (FileSystemException fileSystemException) {}
    }

    @Override
    public String getPropertyHolderName() {
        return this.getName();
    }

    @Override
    @Generated
    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public ServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    @Generated
    public NodeConfig getConfig() {
        return this.config;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public List<String> getLogs() {
        return this.logs;
    }

    @Generated
    public NetworkServer getServer() {
        return this.server;
    }

    @Generated
    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    @Generated
    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    @Generated
    public PlatformManagerImpl getPlatformManager() {
        return this.platformManager;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Override
    @Generated
    public Map<String, Property<?>> getPropertyMap() {
        return this.propertyMap;
    }

    @Generated
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    @Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    @Generated
    public ServiceStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Generated
    public Path getDirectory() {
        return this.directory;
    }

    @Generated
    public Process getServerProcess() {
        return this.serverProcess;
    }

    @Generated
    public BufferedWriter getProcessWriter() {
        return this.processWriter;
    }

    @Generated
    public BufferedReader getProcessReader() {
        return this.processReader;
    }

    @Generated
    public ServiceProcessChecker getProcessChecker() {
        return this.processChecker;
    }

    @Override
    @Generated
    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    @Override
    @Generated
    public void setStatus(ServiceStatus status) {
        this.status = status;
    }

    @Generated
    public void setProcessChecker(ServiceProcessChecker processChecker) {
        this.processChecker = processChecker;
    }
}

