/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.service;

import net.potatocloud.api.event.EventManager;
import net.potatocloud.api.event.events.service.ServiceStoppingEvent;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.node.Node;
import net.potatocloud.node.service.ServiceImpl;

public class ServiceProcessChecker
extends Thread {
    private final ServiceImpl service;

    public ServiceProcessChecker(ServiceImpl service) {
        this.service = service;
        this.setDaemon(true);
        this.setName("ServiceProcessChecker-" + service.getName());
    }

    @Override
    public void run() {
        while (!this.isInterrupted() && this.service.isOnline() && this.service.getServerProcess() != null && this.service.getServerProcess().isAlive()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (!this.isInterrupted()) {
            this.service.getLogger().info("Service &a" + this.service.getName() + " &7seems to be offline...");
            NetworkServer server = Node.getInstance().getServer();
            EventManager eventManager = Node.getInstance().getEventManager();
            if (server != null && eventManager != null) {
                eventManager.call(new ServiceStoppingEvent(this.service.getName()));
            }
            this.service.cleanup();
        }
    }
}

