/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.service;

import java.util.Comparator;
import java.util.List;
import net.potatocloud.api.event.events.property.PropertyChangedEvent;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.property.DefaultProperties;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.api.service.ServiceStatus;
import net.potatocloud.node.Node;

public class ServiceStartQueue
extends Thread {
    private final ServiceGroupManager groupManager;
    private final ServiceManager serviceManager;
    private boolean isRunning = true;

    public ServiceStartQueue(ServiceGroupManager groupManager, ServiceManager serviceManager) {
        this.groupManager = groupManager;
        this.serviceManager = serviceManager;
        this.setName("ServiceStartQueue");
        this.setDaemon(true);
        Node.getInstance().getEventManager().on(PropertyChangedEvent.class, event -> {
            if (!event.getProperty().getName().equals(DefaultProperties.GAME_STATE.getName())) {
                return;
            }
            if (event.getNewValue() == null || !event.getNewValue().equals("INGAME")) {
                return;
            }
            Service service = Node.getInstance().getServiceManager().getService(event.getHolderName());
            if (service == null) {
                return;
            }
            ServiceGroup group = service.getServiceGroup();
            if (group.getOnlineServiceCount() >= group.getMaxOnlineCount()) {
                return;
            }
            serviceManager.startService(service.getServiceGroup());
        });
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                List<ServiceGroup> groups = this.groupManager.getAllServiceGroups().stream().sorted(Comparator.comparingInt(ServiceGroup::getStartPriority).reversed()).toList();
                for (ServiceGroup group : groups) {
                    int groupStartPercentage;
                    int maxPlayers;
                    if (!this.groupManager.existsServiceGroup(group.getName())) continue;
                    List<Service> services = group.getAllServices().stream().filter(service -> service.getStatus() == ServiceStatus.RUNNING || service.getStatus() == ServiceStatus.STARTING || service.getStatus() == ServiceStatus.STOPPING).toList();
                    if (services.size() < group.getMinOnlineCount()) {
                        this.serviceManager.startService(group);
                        continue;
                    }
                    if (services.size() >= group.getMaxOnlineCount() || (maxPlayers = services.stream().mapToInt(Service::getMaxPlayers).sum()) == 0 || (groupStartPercentage = group.getStartPercentage()) == -1) continue;
                    int usagePercent = (int)((double)group.getOnlinePlayerCount() / (double)maxPlayers * 100.0);
                    boolean hasStarting = services.stream().anyMatch(service -> service.getStatus() == ServiceStatus.STARTING);
                    if (usagePercent < groupStartPercentage || hasStarting) continue;
                    this.serviceManager.startService(group);
                    break;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.isRunning = false;
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this.isRunning = false;
        this.interrupt();
    }
}

