/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.setup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.node.Node;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.setup.SetupAnswerResult;
import net.potatocloud.node.setup.SetupManager;
import net.potatocloud.node.setup.SetupQuestion;
import net.potatocloud.node.setup.SetupQuestionBuilder;
import net.potatocloud.node.setup.validator.BooleanValidator;

public abstract class Setup {
    private final Console console;
    private final ScreenManager screenManager;
    private final List<SetupQuestion> questions = new ArrayList<SetupQuestion>();
    protected final Map<String, String> answers = new HashMap<String, String>();
    private int currentIndex = 0;
    private boolean inSummary = false;
    private String lastErrorMessage = null;
    private Screen questionScreen;
    private Screen summaryScreen;

    public abstract String getName();

    public abstract void initQuestions();

    protected abstract void onFinish(Map<String, String> var1);

    public SetupQuestionBuilder question(String name) {
        return new SetupQuestionBuilder(name, this);
    }

    public void start() {
        this.initQuestions();
        if (this.questions.isEmpty()) {
            this.onFinish(this.answers);
            return;
        }
        this.showQuestion();
    }

    public void handleInput(String input) {
        SetupAnswerResult result;
        input = input.strip();
        Node node = Node.getInstance();
        SetupManager setupManager = node.getSetupManager();
        Logger logger = node.getLogger();
        if (input.equalsIgnoreCase("cancel")) {
            this.screenManager.switchScreen("node_screen");
            this.screenManager.removeScreen(this.questionScreen);
            this.screenManager.removeScreen(this.summaryScreen);
            setupManager.endSetup();
            logger.info("Setup &a" + this.getName() + " &7was cancelled");
            return;
        }
        if (this.inSummary) {
            if (input.equalsIgnoreCase("back")) {
                this.inSummary = false;
                this.currentIndex = this.questions.size() - 1;
                this.showQuestion();
                return;
            }
            if (input.equalsIgnoreCase("confirm")) {
                this.screenManager.switchScreen("node_screen");
                this.onFinish(Collections.unmodifiableMap(this.answers));
                this.screenManager.removeScreen(this.questionScreen);
                this.screenManager.removeScreen(this.summaryScreen);
                setupManager.endSetup();
                logger.info("Setup &a" + this.getName() + " &7was completed successfully");
                return;
            }
            this.showSummary();
            return;
        }
        if (input.equalsIgnoreCase("back")) {
            if (this.currentIndex == 0) {
                this.lastErrorMessage = "You are already at the first question";
            } else {
                --this.currentIndex;
            }
            this.showQuestion();
            return;
        }
        if (this.currentIndex >= this.questions.size()) {
            return;
        }
        SetupQuestion question = this.questions.get(this.currentIndex);
        String answer = input;
        if (question.getValidator() != null && question.getValidator() instanceof BooleanValidator) {
            if (answer.equalsIgnoreCase("yes")) {
                answer = "true";
            }
            if (answer.equalsIgnoreCase("no")) {
                answer = "false";
            }
        }
        String defaultAnswer = question.getDefaultAnswer();
        if (input.isEmpty()) {
            if (defaultAnswer != null && !defaultAnswer.isBlank()) {
                answer = defaultAnswer;
            } else {
                this.lastErrorMessage = "The input cannot be blank";
                this.showQuestion();
                return;
            }
        }
        if (question.getValidator() != null && !(result = question.getValidator().validate(answer)).isSuccess()) {
            this.lastErrorMessage = result.getErrorMessage();
            this.showQuestion();
            return;
        }
        this.answers.put(question.getName(), answer);
        this.lastErrorMessage = null;
        ++this.currentIndex;
        if (this.currentIndex < this.questions.size()) {
            this.showQuestion();
            return;
        }
        this.showSummary();
    }

    private void showQuestion() {
        String previousAnswer;
        while (this.currentIndex < this.questions.size() && this.questions.get(this.currentIndex).shouldSkip(this.answers)) {
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.questions.size()) {
            this.showSummary();
            return;
        }
        SetupQuestion question = this.questions.get(this.currentIndex);
        String screenName = "setup_" + this.getName().toLowerCase();
        this.questionScreen = new Screen(screenName);
        this.screenManager.addScreen(this.questionScreen);
        this.screenManager.switchScreen(screenName, false);
        this.console.setPrompt("> ");
        this.console.println("&7Setup: &a" + this.getName() + " &8(&7Question &a" + (this.currentIndex + 1) + "&8/&a" + this.questions.size() + "&8)");
        this.console.println(" ");
        this.console.println("&8\u00bb &7" + question.getQuestion());
        if (question.getDefaultAnswer() != null && !question.getDefaultAnswer().isBlank()) {
            this.console.println("  &8\u2022 &7Default&8: &a" + question.getDefaultAnswer());
        }
        if ((previousAnswer = this.answers.get(question.getName())) != null && !previousAnswer.isBlank()) {
            this.console.println("  &8\u2022 &7Previous&8: &a" + previousAnswer);
        }
        ArrayList<String> commandsText = new ArrayList<String>();
        if (question.getDefaultAnswer() != null && !question.getDefaultAnswer().isBlank()) {
            commandsText.add("&aEnter&7 = default");
        }
        if (question.getPossibleChoices(this.answers) != null && !question.getPossibleChoices(this.answers).isEmpty()) {
            commandsText.add("&aTab&7 = show options");
        }
        if (this.currentIndex != 0) {
            commandsText.add("&aBack&7 = previous question");
        }
        commandsText.add("&aCancel&7 = exit the setup");
        this.console.println(" ");
        this.console.println("&7Commands&8: &7" + String.join((CharSequence)" &8| &7", commandsText));
        this.console.println(" ");
        if (this.lastErrorMessage != null) {
            this.console.println("&c" + this.lastErrorMessage);
        }
    }

    private void showSummary() {
        this.inSummary = true;
        String screenName = "setup_" + this.getName().toLowerCase() + "_summary";
        this.summaryScreen = new Screen(screenName);
        this.screenManager.addScreen(this.summaryScreen);
        this.screenManager.switchScreen(screenName, false);
        this.console.setPrompt("> ");
        this.console.println("&7Setup: &a" + this.getName() + " &8(&7Summary&8)");
        this.console.println("");
        for (SetupQuestion question : this.questions) {
            String answer = this.answers.getOrDefault(question.getName(), "<no answer>");
            this.console.println("&8\u00bb &7" + question.getQuestion());
            this.console.println("  &8\u2022 &7Answer: &a" + answer);
            this.console.println(" ");
        }
        this.console.println("");
        this.console.println("Type &aconfirm&7 to complete the setup, &aback&7 to return to the questions, or &ccancel&7 to exit the setup");
    }

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Generated
    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    @Generated
    public List<SetupQuestion> getQuestions() {
        return this.questions;
    }

    @Generated
    public Map<String, String> getAnswers() {
        return this.answers;
    }

    @Generated
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Generated
    public boolean isInSummary() {
        return this.inSummary;
    }

    @Generated
    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    @Generated
    public Screen getQuestionScreen() {
        return this.questionScreen;
    }

    @Generated
    public Screen getSummaryScreen() {
        return this.summaryScreen;
    }

    @Generated
    public Setup(Console console, ScreenManager screenManager) {
        this.console = console;
        this.screenManager = screenManager;
    }
}

