/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.template;

import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import net.potatocloud.node.console.Logger;
import org.apache.commons.io.FileUtils;

public class TemplateManager {
    private final Logger logger;
    private final Path templatesFolder;

    public void createTemplate(String templateName) {
        File templateFolder = this.templatesFolder.resolve(templateName).toFile();
        if (!templateFolder.exists()) {
            templateFolder.mkdirs();
        }
    }

    public void copyTemplate(String templateName, Path serviceDirectory) {
        File sourceFolder = this.templatesFolder.resolve(templateName).toFile();
        if (!sourceFolder.exists()) {
            this.logger.error("Template " + templateName + " does not exists!");
            return;
        }
        FileUtils.copyDirectory(sourceFolder, serviceDirectory.toFile());
    }

    @Generated
    public TemplateManager(Logger logger, Path templatesFolder) {
        this.logger = logger;
        this.templatesFolder = templatesFolder;
    }
}

