/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.plugin.limbo;

import com.loohp.limbo.events.EventHandler;
import com.loohp.limbo.events.Listener;
import com.loohp.limbo.events.player.PlayerLoginEvent;
import com.loohp.limbo.events.status.StatusPingEvent;
import net.kyori.adventure.text.Component;
import net.potatocloud.api.service.Service;
import net.potatocloud.connector.ConnectorAPI;
import net.potatocloud.plugin.PlatformPlugin;

public class LimboPlugin
extends com.loohp.limbo.plugins.LimboPlugin
implements Listener,
PlatformPlugin {
    private ConnectorAPI api;
    private Service currentService;

    public void onLoad() {
        this.api = new ConnectorAPI();
    }

    public void onEnable() {
        this.initCurrentService();
        this.getServer().getEventsManager().registerEvents((com.loohp.limbo.plugins.LimboPlugin)this, (Listener)this);
    }

    @Override
    public void onServiceReady(Service service) {
        this.currentService = service;
    }

    @EventHandler
    public void onStatusPing(StatusPingEvent event) {
        if (this.currentService == null) {
            return;
        }
        event.setMaxPlayers(this.currentService.getMaxPlayers());
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (this.currentService == null) {
            return;
        }
        if (this.getServer().getPlayers().size() < this.currentService.getMaxPlayers()) {
            return;
        }
        if (event.getConnection().getPlayer().hasPermission("potatocloud.maxplayers.bypass")) {
            return;
        }
        event.setCancelReason((Component)Component.text((String)"\u00a7cThe server has reached its maximum players!"));
        event.setCancelled(true);
    }

    @Override
    public void runTaskLater(Runnable task, int delaySeconds) {
        this.getServer().getScheduler().runTaskLater((com.loohp.limbo.plugins.LimboPlugin)this, task::run, (long)delaySeconds * 20L);
    }

    public void onDisable() {
        this.api.shutdown();
    }
}

