/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.plugin.spigot;

import net.potatocloud.api.service.Service;
import net.potatocloud.connector.ConnectorAPI;
import net.potatocloud.plugin.PlatformPlugin;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPlugin
extends JavaPlugin
implements Listener,
PlatformPlugin {
    private ConnectorAPI api;
    private Service currentService;

    public void onLoad() {
        this.api = new ConnectorAPI();
    }

    public void onEnable() {
        this.initCurrentService();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @Override
    public void onServiceReady(Service service) {
        this.currentService = service;
    }

    @EventHandler
    public void onServerListPing(ServerListPingEvent event) {
        if (this.currentService == null) {
            return;
        }
        event.setMaxPlayers(this.currentService.getMaxPlayers());
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (this.currentService == null) {
            return;
        }
        if (this.getServer().getOnlinePlayers().size() < this.currentService.getMaxPlayers()) {
            return;
        }
        if (event.getPlayer().hasPermission("potatocloud.maxplayers.bypass")) {
            return;
        }
        event.disallow(PlayerLoginEvent.Result.KICK_FULL, "\u00a7cThe server has reached its maximum players!");
    }

    @Override
    public void runTaskLater(Runnable task, int delaySeconds) {
        this.getServer().getScheduler().runTaskLater((Plugin)this, task, (long)delaySeconds * 20L);
    }

    public void onDisable() {
        this.api.shutdown();
    }
}

