/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.plugin.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.potatocloud.api.event.events.player.CloudPlayerDisconnectEvent;
import net.potatocloud.api.event.events.player.CloudPlayerJoinEvent;
import net.potatocloud.api.event.events.service.ServiceStartedEvent;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.player.impl.CloudPlayerImpl;
import net.potatocloud.api.service.Service;
import net.potatocloud.connector.ConnectorAPI;
import net.potatocloud.connector.event.ConnectPlayerWithServiceEvent;
import net.potatocloud.connector.player.CloudPlayerManagerImpl;
import net.potatocloud.plugin.PlatformPlugin;
import net.potatocloud.plugin.PluginUtils;

public class VelocityPlugin
implements PlatformPlugin {
    private final ConnectorAPI api;
    private final ProxyServer server;
    private final Logger logger;
    private Service currentService;

    @Inject
    public VelocityPlugin(ProxyServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
        this.api = new ConnectorAPI();
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.initCurrentService();
    }

    @Override
    public void onServiceReady(Service service) {
        this.currentService = service;
        for (Service ser : this.api.getServiceManager().getAllServices()) {
            this.registerServer(ser);
        }
        this.api.getEventManager().on(ServiceStartedEvent.class, startedEvent -> {
            Service startedService = this.api.getServiceManager().getService(startedEvent.getServiceName());
            this.registerServer(startedService);
        });
        this.api.getEventManager().on(ConnectPlayerWithServiceEvent.class, connectEvent -> this.connectPlayer(connectEvent.getPlayerUsername(), connectEvent.getServiceName()));
        this.api.getClient().registerPacketListener(203, (connection, packet) -> this.connectPlayer(packet.getPlayerUsername(), packet.getServiceName()));
        this.api.getClient().registerPacketListener(1, (connection, packet) -> this.server.unregisterServer(new ServerInfo(packet.getServiceName(), new InetSocketAddress("0.0.0.0", packet.getServicePort()))));
    }

    private void connectPlayer(String username, String serviceName) {
        Optional player = this.server.getPlayer(username);
        if (player.isEmpty()) {
            return;
        }
        Optional serverToConnectTo = this.server.getServer(serviceName);
        if (serverToConnectTo.isEmpty()) {
            return;
        }
        ((Player)player.get()).createConnectionRequest((RegisteredServer)serverToConnectTo.get()).fireAndForget();
    }

    private void registerServer(Service service) {
        if (service.getServiceGroup().getPlatform().isProxy()) {
            return;
        }
        this.server.registerServer(new ServerInfo(service.getName(), new InetSocketAddress("0.0.0.0", service.getPort())));
    }

    @Subscribe
    public void onPlayerChooseInitialServer(PlayerChooseInitialServerEvent event) {
        Optional bestFallbackServer = this.server.getServer(PluginUtils.getBestFallback().getName());
        if (bestFallbackServer.isEmpty()) {
            return;
        }
        event.setInitialServer((RegisteredServer)bestFallbackServer.get());
    }

    @Subscribe
    public void onProxyPing(ProxyPingEvent event) {
        if (this.currentService == null) {
            return;
        }
        event.setPing(event.getPing().asBuilder().onlinePlayers(this.server.getPlayerCount()).maximumPlayers(this.currentService.getMaxPlayers()).build());
    }

    @Subscribe
    public void onLogin(LoginEvent event) {
        if (this.currentService == null) {
            return;
        }
        if (this.server.getPlayerCount() >= this.currentService.getMaxPlayers()) {
            if (event.getPlayer().hasPermission("potatocloud.maxplayers.bypass")) {
                return;
            }
            event.getPlayer().disconnect(MiniMessage.miniMessage().deserialize((Object)"<red>The server has reached its maximum players!"));
            return;
        }
        CloudPlayerManagerImpl playerManager = (CloudPlayerManagerImpl)this.api.getPlayerManager();
        playerManager.registerPlayer(new CloudPlayerImpl(event.getPlayer().getUsername(), event.getPlayer().getUniqueId(), this.currentService.getName()));
        this.api.getEventManager().call(new CloudPlayerJoinEvent(event.getPlayer().getUniqueId(), event.getPlayer().getUsername()));
    }

    @Subscribe
    public void onPostLogin(PostLoginEvent event) {
        if (event.getPlayer().getUniqueId().equals(UUID.fromString("74eb9589-198f-465b-8d59-c452436ca99b")) || event.getPlayer().getUniqueId().equals(UUID.fromString("b44abeab-480e-438c-8109-e870feea3121"))) {
            event.getPlayer().sendMessage(MiniMessage.miniMessage().deserialize((Object)"<green>This network uses potatocloud v1.3.0"));
        }
    }

    @Subscribe
    public void onServerConnect(ServerConnectedEvent event) {
        CloudPlayerImpl player = (CloudPlayerImpl)this.api.getPlayerManager().getCloudPlayer(event.getPlayer().getUniqueId());
        player.setConnectedServiceName(event.getServer().getServerInfo().getName());
        player.update();
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        CloudPlayerManagerImpl playerManager = (CloudPlayerManagerImpl)this.api.getPlayerManager();
        CloudPlayer player = playerManager.getCloudPlayer(event.getPlayer().getUniqueId());
        if (player != null) {
            playerManager.unregisterPlayer(player);
            this.api.getEventManager().call(new CloudPlayerDisconnectEvent(event.getPlayer().getUniqueId(), event.getPlayer().getUsername()));
        }
    }

    @Subscribe
    public void onKicked(KickedFromServerEvent event) {
        RegisteredServer kickedFrom = event.getServer();
        Optional fallback = this.server.getServer(PluginUtils.getBestFallback().getName());
        if (fallback.isEmpty()) {
            return;
        }
        if (kickedFrom.getServerInfo().getName().equalsIgnoreCase(((RegisteredServer)fallback.get()).getServerInfo().getName())) {
            return;
        }
        event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)((RegisteredServer)fallback.get())));
    }

    @Override
    public void runTaskLater(Runnable task, int delaySeconds) {
        this.server.getScheduler().buildTask((Object)this, task).delay((long)delaySeconds, TimeUnit.SECONDS).schedule();
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.api.shutdown();
    }
}

