/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.group.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;

public class ServiceGroupImpl
implements ServiceGroup {
    private final String name;
    private final String platformName;
    private final String platformVersionName;
    private final List<String> serviceTemplates;
    private int minOnlineCount;
    private int maxOnlineCount;
    private int maxPlayers;
    private int maxMemory;
    private boolean fallback;
    private boolean isStatic;
    private int startPriority;
    private int startPercentage;
    private String javaCommand;
    private List<String> customJvmFlags;
    private final Map<String, Property<?>> propertyMap;

    public ServiceGroupImpl(String name, String platformName, String platformVersionName, int minOnlineCount, int maxOnlineCount, int maxPlayers, int maxMemory, boolean fallback, boolean isStatic, int startPriority, int startPercentage, String javaCommand, List<String> customJvmFlags, Map<String, Property<?>> propertyMap) {
        this.name = name;
        this.platformName = platformName;
        this.platformVersionName = platformVersionName;
        this.minOnlineCount = minOnlineCount;
        this.maxOnlineCount = maxOnlineCount;
        this.maxPlayers = maxPlayers;
        this.maxMemory = maxMemory;
        this.fallback = fallback;
        this.isStatic = isStatic;
        this.startPriority = startPriority;
        this.startPercentage = startPercentage;
        this.javaCommand = javaCommand;
        this.customJvmFlags = customJvmFlags;
        this.propertyMap = propertyMap;
        this.serviceTemplates = new ArrayList<String>();
        this.addServiceTemplate("every");
        this.addServiceTemplate(name);
        Platform platform = this.getPlatform();
        if (platform == null) {
            return;
        }
        if (platform.isProxy()) {
            this.addServiceTemplate("every_proxy");
        } else {
            this.addServiceTemplate("every_service");
        }
    }

    @Override
    public String getPropertyHolderName() {
        return this.getName();
    }

    @Override
    public <T> void setProperty(Property<T> property, T value) {
        ServiceGroup.super.setProperty(property, value);
        Property prop = this.getProperty(property.getName());
        if (prop != null) {
            for (Service service : this.getAllServices()) {
                service.setProperty(prop, prop.getValue(), false);
                service.update();
            }
        }
    }

    @Override
    public void addCustomJvmFlag(String flag) {
        this.customJvmFlags.add(flag);
    }

    @Override
    public void addServiceTemplate(String template) {
        if (this.serviceTemplates.contains(template)) {
            return;
        }
        this.serviceTemplates.add(template);
    }

    @Override
    public void removeServiceTemplate(String template) {
        if (!this.serviceTemplates.contains(template)) {
            return;
        }
        this.serviceTemplates.remove(template);
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getPlatformName() {
        return this.platformName;
    }

    @Override
    @Generated
    public String getPlatformVersionName() {
        return this.platformVersionName;
    }

    @Override
    @Generated
    public List<String> getServiceTemplates() {
        return this.serviceTemplates;
    }

    @Override
    @Generated
    public int getMinOnlineCount() {
        return this.minOnlineCount;
    }

    @Override
    @Generated
    public int getMaxOnlineCount() {
        return this.maxOnlineCount;
    }

    @Override
    @Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    @Generated
    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    @Generated
    public boolean isFallback() {
        return this.fallback;
    }

    @Override
    @Generated
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    @Generated
    public int getStartPriority() {
        return this.startPriority;
    }

    @Override
    @Generated
    public int getStartPercentage() {
        return this.startPercentage;
    }

    @Override
    @Generated
    public String getJavaCommand() {
        return this.javaCommand;
    }

    @Override
    @Generated
    public List<String> getCustomJvmFlags() {
        return this.customJvmFlags;
    }

    @Override
    @Generated
    public Map<String, Property<?>> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    @Generated
    public void setMinOnlineCount(int minOnlineCount) {
        this.minOnlineCount = minOnlineCount;
    }

    @Override
    @Generated
    public void setMaxOnlineCount(int maxOnlineCount) {
        this.maxOnlineCount = maxOnlineCount;
    }

    @Override
    @Generated
    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    @Override
    @Generated
    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Override
    @Generated
    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    @Generated
    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    @Override
    @Generated
    public void setStartPriority(int startPriority) {
        this.startPriority = startPriority;
    }

    @Override
    @Generated
    public void setStartPercentage(int startPercentage) {
        this.startPercentage = startPercentage;
    }

    @Generated
    public void setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
    }

    @Generated
    public void setCustomJvmFlags(List<String> customJvmFlags) {
        this.customJvmFlags = customJvmFlags;
    }

    @Generated
    public ServiceGroupImpl(String name, String platformName, String platformVersionName, List<String> serviceTemplates, int minOnlineCount, int maxOnlineCount, int maxPlayers, int maxMemory, boolean fallback, boolean isStatic, int startPriority, int startPercentage, String javaCommand, List<String> customJvmFlags, Map<String, Property<?>> propertyMap) {
        this.name = name;
        this.platformName = platformName;
        this.platformVersionName = platformVersionName;
        this.serviceTemplates = serviceTemplates;
        this.minOnlineCount = minOnlineCount;
        this.maxOnlineCount = maxOnlineCount;
        this.maxPlayers = maxPlayers;
        this.maxMemory = maxMemory;
        this.fallback = fallback;
        this.isStatic = isStatic;
        this.startPriority = startPriority;
        this.startPercentage = startPercentage;
        this.javaCommand = javaCommand;
        this.customJvmFlags = customJvmFlags;
        this.propertyMap = propertyMap;
    }
}

